/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.service.validator;

import de.adorsys.psd2.xs2a.core.consent.ConsentStatus;
import de.adorsys.psd2.xs2a.core.piis.PiisConsent;
import de.adorsys.psd2.xs2a.core.piis.PiisConsentTppAccessType;
import de.adorsys.psd2.xs2a.core.tpp.TppInfo;
import de.adorsys.psd2.xs2a.domain.ErrorHolder;
import de.adorsys.psd2.xs2a.domain.MessageErrorCode;
import de.adorsys.psd2.xs2a.domain.fund.PiisConsentValidationResult;
import de.adorsys.psd2.xs2a.service.TppService;
import java.beans.ConstructorProperties;
import java.time.LocalDate;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class PiisConsentValidationService {
    private static final Logger log = LoggerFactory.getLogger(PiisConsentValidationService.class);
    private final TppService tppService;

    public PiisConsentValidationResult validatePiisConsentData(List<PiisConsent> piisConsents) {
        if (CollectionUtils.isEmpty(piisConsents)) {
            return new PiisConsentValidationResult(ErrorHolder.builder(MessageErrorCode.NO_PIIS_ACTIVATION).build());
        }
        List filteredResponse = piisConsents.stream().filter(e -> EnumSet.of(ConsentStatus.VALID, ConsentStatus.RECEIVED).contains(e.getConsentStatus())).filter(e -> Optional.ofNullable(e.getExpireDate()).map(d -> d.compareTo(LocalDate.now()) >= 0).orElse(true)).filter(this::isTppValid).collect(Collectors.toList());
        if (filteredResponse.isEmpty()) {
            return new PiisConsentValidationResult(ErrorHolder.builder(MessageErrorCode.CONSENT_INVALID).build());
        }
        Optional<PiisConsent> validResponse = filteredResponse.stream().filter(e -> e.getAllowedFrequencyPerDay() > 0).findAny();
        return validResponse.map(PiisConsentValidationResult::new).orElseGet(() -> new PiisConsentValidationResult(ErrorHolder.builder(MessageErrorCode.ACCESS_EXCEEDED).build()));
    }

    private boolean isTppValid(PiisConsent piisConsent) {
        switch (piisConsent.getTppAccessType()) {
            case ALL_TPP: {
                return true;
            }
            case SINGLE_TPP: {
                TppInfo tppInfo = piisConsent.getTppInfo();
                if (tppInfo == null) {
                    return false;
                }
                String tppIdFromConsent = tppInfo.getAuthorisationNumber();
                String actualTppId = this.tppService.getTppId();
                return tppIdFromConsent.equals(actualTppId);
            }
        }
        PiisConsentTppAccessType accessType = piisConsent.getTppAccessType();
        log.error("Unknown TPP access type: {}", (Object)accessType);
        throw new IllegalArgumentException("Unknown TPP access type: " + accessType);
    }

    @ConstructorProperties(value={"tppService"})
    public PiisConsentValidationService(TppService tppService) {
        this.tppService = tppService;
    }
}

