/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.service.payment;

import de.adorsys.psd2.xs2a.core.consent.AspspConsentData;
import de.adorsys.psd2.xs2a.core.psu.PsuIdData;
import de.adorsys.psd2.xs2a.core.tpp.TppInfo;
import de.adorsys.psd2.xs2a.domain.pis.CommonPayment;
import de.adorsys.psd2.xs2a.domain.pis.CommonPaymentInitiationResponse;
import de.adorsys.psd2.xs2a.service.context.SpiContextDataProvider;
import de.adorsys.psd2.xs2a.service.mapper.spi_xs2a_mappers.SpiErrorMapper;
import de.adorsys.psd2.xs2a.service.mapper.spi_xs2a_mappers.SpiToXs2aPaymentMapper;
import de.adorsys.psd2.xs2a.service.payment.ScaCommonPaymentService;
import de.adorsys.psd2.xs2a.spi.domain.SpiContextData;
import de.adorsys.psd2.xs2a.spi.domain.payment.SpiPaymentInfo;
import de.adorsys.psd2.xs2a.spi.domain.payment.response.SpiPaymentInitiationResponse;
import de.adorsys.psd2.xs2a.spi.domain.response.SpiResponse;
import de.adorsys.psd2.xs2a.spi.service.CommonPaymentSpi;
import java.beans.ConstructorProperties;
import org.springframework.stereotype.Service;

@Service
public class RedirectAndEmbeddedCommonPaymentService
implements ScaCommonPaymentService {
    private final CommonPaymentSpi commonPaymentSpi;
    private final SpiToXs2aPaymentMapper spiToXs2aPaymentMapper;
    private final SpiContextDataProvider spiContextDataProvider;
    private final SpiErrorMapper spiErrorMapper;

    @Override
    public CommonPaymentInitiationResponse createPayment(CommonPayment payment, TppInfo tppInfo, String paymentProduct, PsuIdData psuIdData) {
        SpiContextData spiContextData = this.spiContextDataProvider.provide(psuIdData, tppInfo);
        SpiResponse spiResponse = this.commonPaymentSpi.initiatePayment(spiContextData, this.mapToSpiPaymentRequest(payment, paymentProduct), AspspConsentData.emptyConsentData());
        if (spiResponse.hasError()) {
            return new CommonPaymentInitiationResponse(this.spiErrorMapper.mapToErrorHolder(spiResponse));
        }
        return this.spiToXs2aPaymentMapper.mapToCommonPaymentInitiateResponse((SpiPaymentInitiationResponse)spiResponse.getPayload(), payment.getPaymentType(), spiResponse.getAspspConsentData());
    }

    private SpiPaymentInfo mapToSpiPaymentRequest(CommonPayment payment, String paymentProduct) {
        SpiPaymentInfo request = new SpiPaymentInfo(paymentProduct);
        request.setPaymentId(payment.getPaymentId());
        request.setPaymentType(payment.getPaymentType());
        request.setPaymentData(payment.getPaymentData());
        return request;
    }

    @ConstructorProperties(value={"commonPaymentSpi", "spiToXs2aPaymentMapper", "spiContextDataProvider", "spiErrorMapper"})
    public RedirectAndEmbeddedCommonPaymentService(CommonPaymentSpi commonPaymentSpi, SpiToXs2aPaymentMapper spiToXs2aPaymentMapper, SpiContextDataProvider spiContextDataProvider, SpiErrorMapper spiErrorMapper) {
        this.commonPaymentSpi = commonPaymentSpi;
        this.spiToXs2aPaymentMapper = spiToXs2aPaymentMapper;
        this.spiContextDataProvider = spiContextDataProvider;
        this.spiErrorMapper = spiErrorMapper;
    }
}

