/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.service.payment;

import de.adorsys.psd2.consent.api.pis.PisPayment;
import de.adorsys.psd2.xs2a.core.consent.AspspConsentData;
import de.adorsys.psd2.xs2a.service.payment.ReadPaymentStatusService;
import de.adorsys.psd2.xs2a.service.payment.SpiPaymentFactory;
import de.adorsys.psd2.xs2a.spi.domain.SpiContextData;
import de.adorsys.psd2.xs2a.spi.domain.common.SpiTransactionStatus;
import de.adorsys.psd2.xs2a.spi.domain.payment.SpiSinglePayment;
import de.adorsys.psd2.xs2a.spi.domain.response.SpiResponse;
import de.adorsys.psd2.xs2a.spi.domain.response.SpiResponseStatus;
import de.adorsys.psd2.xs2a.spi.service.SinglePaymentSpi;
import java.beans.ConstructorProperties;
import java.util.List;
import java.util.Optional;
import org.springframework.stereotype.Service;

@Service(value="status-payments")
public class ReadSinglePaymentStatusService
implements ReadPaymentStatusService {
    private final SpiPaymentFactory spiPaymentFactory;
    private final SinglePaymentSpi singlePaymentSpi;

    @Override
    public SpiResponse<SpiTransactionStatus> readPaymentStatus(List<PisPayment> pisPayments, String paymentProduct, SpiContextData spiContextData, AspspConsentData aspspConsentData) {
        Optional<SpiSinglePayment> spiSinglePaymentOptional = this.spiPaymentFactory.createSpiSinglePayment(pisPayments.get(0), paymentProduct);
        return spiSinglePaymentOptional.map(spiSinglePayment -> this.singlePaymentSpi.getPaymentStatusById(spiContextData, spiSinglePayment, aspspConsentData)).orElseGet(() -> SpiResponse.builder().message("Payment not found").fail(SpiResponseStatus.LOGICAL_FAILURE));
    }

    @ConstructorProperties(value={"spiPaymentFactory", "singlePaymentSpi"})
    public ReadSinglePaymentStatusService(SpiPaymentFactory spiPaymentFactory, SinglePaymentSpi singlePaymentSpi) {
        this.spiPaymentFactory = spiPaymentFactory;
        this.singlePaymentSpi = singlePaymentSpi;
    }
}

