/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.service.payment;

import de.adorsys.psd2.consent.api.pis.PisPayment;
import de.adorsys.psd2.xs2a.core.consent.AspspConsentData;
import de.adorsys.psd2.xs2a.service.payment.ReadPaymentStatusService;
import de.adorsys.psd2.xs2a.service.payment.SpiPaymentFactory;
import de.adorsys.psd2.xs2a.spi.domain.SpiContextData;
import de.adorsys.psd2.xs2a.spi.domain.common.SpiTransactionStatus;
import de.adorsys.psd2.xs2a.spi.domain.payment.SpiPeriodicPayment;
import de.adorsys.psd2.xs2a.spi.domain.response.SpiResponse;
import de.adorsys.psd2.xs2a.spi.domain.response.SpiResponseStatus;
import de.adorsys.psd2.xs2a.spi.service.PeriodicPaymentSpi;
import java.beans.ConstructorProperties;
import java.util.List;
import java.util.Optional;
import org.springframework.stereotype.Service;

@Service(value="status-periodic-payments")
public class ReadPeriodicPaymentStatusService
implements ReadPaymentStatusService {
    private final SpiPaymentFactory spiPaymentFactory;
    private final PeriodicPaymentSpi periodicPaymentSpi;

    @Override
    public SpiResponse<SpiTransactionStatus> readPaymentStatus(List<PisPayment> pisPayments, String paymentProduct, SpiContextData spiContextData, AspspConsentData aspspConsentData) {
        Optional<SpiPeriodicPayment> spiPeriodicPaymentOptional = this.spiPaymentFactory.createSpiPeriodicPayment(pisPayments.get(0), paymentProduct);
        return spiPeriodicPaymentOptional.map(spiPeriodicPayment -> this.periodicPaymentSpi.getPaymentStatusById(spiContextData, spiPeriodicPayment, aspspConsentData)).orElseGet(() -> SpiResponse.builder().message("Payment not found").fail(SpiResponseStatus.LOGICAL_FAILURE));
    }

    @ConstructorProperties(value={"spiPaymentFactory", "periodicPaymentSpi"})
    public ReadPeriodicPaymentStatusService(SpiPaymentFactory spiPaymentFactory, PeriodicPaymentSpi periodicPaymentSpi) {
        this.spiPaymentFactory = spiPaymentFactory;
        this.periodicPaymentSpi = periodicPaymentSpi;
    }
}

