/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.service.payment;

import de.adorsys.psd2.consent.api.pis.PisPayment;
import de.adorsys.psd2.xs2a.core.consent.AspspConsentData;
import de.adorsys.psd2.xs2a.service.payment.ReadPaymentStatusService;
import de.adorsys.psd2.xs2a.service.payment.SpiPaymentFactory;
import de.adorsys.psd2.xs2a.spi.domain.SpiContextData;
import de.adorsys.psd2.xs2a.spi.domain.common.SpiTransactionStatus;
import de.adorsys.psd2.xs2a.spi.domain.payment.SpiBulkPayment;
import de.adorsys.psd2.xs2a.spi.domain.response.SpiResponse;
import de.adorsys.psd2.xs2a.spi.domain.response.SpiResponseStatus;
import de.adorsys.psd2.xs2a.spi.service.BulkPaymentSpi;
import java.beans.ConstructorProperties;
import java.util.List;
import java.util.Optional;
import org.springframework.stereotype.Service;

@Service(value="status-bulk-payments")
public class ReadBulkPaymentStatusService
implements ReadPaymentStatusService {
    private final SpiPaymentFactory spiPaymentFactory;
    private final BulkPaymentSpi bulkPaymentSpi;

    @Override
    public SpiResponse<SpiTransactionStatus> readPaymentStatus(List<PisPayment> pisPayments, String paymentProduct, SpiContextData spiContextData, AspspConsentData aspspConsentData) {
        Optional<SpiBulkPayment> spiBulkPaymentOptional = this.spiPaymentFactory.createSpiBulkPayment(pisPayments, paymentProduct);
        return spiBulkPaymentOptional.map(spiBulkPayment -> this.bulkPaymentSpi.getPaymentStatusById(spiContextData, spiBulkPayment, aspspConsentData)).orElseGet(() -> SpiResponse.builder().message("Payment not found").fail(SpiResponseStatus.LOGICAL_FAILURE));
    }

    @ConstructorProperties(value={"spiPaymentFactory", "bulkPaymentSpi"})
    public ReadBulkPaymentStatusService(SpiPaymentFactory spiPaymentFactory, BulkPaymentSpi bulkPaymentSpi) {
        this.spiPaymentFactory = spiPaymentFactory;
        this.bulkPaymentSpi = bulkPaymentSpi;
    }
}

