/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.service.payment;

import de.adorsys.psd2.consent.api.pis.proto.PisPaymentInfo;
import de.adorsys.psd2.xs2a.core.consent.AspspConsentData;
import de.adorsys.psd2.xs2a.core.psu.PsuIdData;
import de.adorsys.psd2.xs2a.core.tpp.TppInfo;
import de.adorsys.psd2.xs2a.domain.MessageErrorCode;
import de.adorsys.psd2.xs2a.domain.ResponseObject;
import de.adorsys.psd2.xs2a.domain.consent.Xs2aCreatePisAuthorisationResponse;
import de.adorsys.psd2.xs2a.domain.consent.Xs2aPisCommonPayment;
import de.adorsys.psd2.xs2a.domain.pis.CommonPayment;
import de.adorsys.psd2.xs2a.domain.pis.PaymentInitiationParameters;
import de.adorsys.psd2.xs2a.domain.pis.PaymentInitiationResponse;
import de.adorsys.psd2.xs2a.exception.MessageError;
import de.adorsys.psd2.xs2a.service.authorization.AuthorisationMethodDecider;
import de.adorsys.psd2.xs2a.service.authorization.pis.PisScaAuthorisationService;
import de.adorsys.psd2.xs2a.service.consent.PisAspspDataService;
import de.adorsys.psd2.xs2a.service.consent.Xs2aPisCommonPaymentService;
import de.adorsys.psd2.xs2a.service.mapper.consent.Xs2aPisCommonPaymentMapper;
import de.adorsys.psd2.xs2a.service.mapper.consent.Xs2aToCmsPisCommonPaymentRequestMapper;
import de.adorsys.psd2.xs2a.service.payment.CreatePaymentService;
import de.adorsys.psd2.xs2a.service.payment.ScaCommonPaymentService;
import java.beans.ConstructorProperties;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

@Service
public class CreateCommonPaymentService
implements CreatePaymentService<CommonPayment, PaymentInitiationResponse> {
    private final ScaCommonPaymentService scaPaymentService;
    private final Xs2aPisCommonPaymentService pisCommonPaymentService;
    private final AuthorisationMethodDecider authorisationMethodDecider;
    private final PisScaAuthorisationService pisScaAuthorisationService;
    private final PisAspspDataService pisAspspDataService;
    private final Xs2aPisCommonPaymentMapper xs2aPisCommonPaymentMapper;
    private final Xs2aToCmsPisCommonPaymentRequestMapper xs2aToCmsPisCommonPaymentRequestMapper;

    @Override
    public ResponseObject<PaymentInitiationResponse> createPayment(CommonPayment payment, PaymentInitiationParameters paymentInitiationParameters, TppInfo tppInfo) {
        PsuIdData psuData = paymentInitiationParameters.getPsuData();
        PaymentInitiationResponse response = this.scaPaymentService.createPayment(payment, tppInfo, paymentInitiationParameters.getPaymentProduct(), psuData);
        PisPaymentInfo pisPaymentInfo = this.xs2aToCmsPisCommonPaymentRequestMapper.mapToPisPaymentInfo(paymentInitiationParameters, tppInfo, response, payment.getPaymentData());
        Xs2aPisCommonPayment pisCommonPayment = this.xs2aPisCommonPaymentMapper.mapToXs2aPisCommonPayment(this.pisCommonPaymentService.createCommonPayment(pisPaymentInfo), psuData);
        String externalPaymentId = pisCommonPayment.getPaymentId();
        if (StringUtils.isBlank((CharSequence)externalPaymentId)) {
            return ResponseObject.builder().fail(new MessageError(MessageErrorCode.PAYMENT_FAILED)).build();
        }
        AspspConsentData aspspConsentData = response.getAspspConsentData();
        this.pisAspspDataService.updateAspspConsentData(new AspspConsentData(aspspConsentData.getAspspConsentData(), externalPaymentId));
        response.setPaymentId(externalPaymentId);
        boolean implicitMethod = this.authorisationMethodDecider.isImplicitMethod(paymentInitiationParameters.isTppExplicitAuthorisationPreferred());
        if (implicitMethod) {
            Optional<Xs2aCreatePisAuthorisationResponse> consentAuthorisation = this.pisScaAuthorisationService.createCommonPaymentAuthorisation(externalPaymentId, payment.getPaymentType(), paymentInitiationParameters.getPsuData());
            if (!consentAuthorisation.isPresent()) {
                return ResponseObject.builder().fail(new MessageError(MessageErrorCode.PAYMENT_FAILED)).build();
            }
            Xs2aCreatePisAuthorisationResponse authorisationResponse = consentAuthorisation.get();
            response.setAuthorizationId(authorisationResponse.getAuthorisationId());
            response.setScaStatus(authorisationResponse.getScaStatus());
        }
        return ResponseObject.builder().body(response).build();
    }

    @ConstructorProperties(value={"scaPaymentService", "pisCommonPaymentService", "authorisationMethodDecider", "pisScaAuthorisationService", "pisAspspDataService", "xs2aPisCommonPaymentMapper", "xs2aToCmsPisCommonPaymentRequestMapper"})
    public CreateCommonPaymentService(ScaCommonPaymentService scaPaymentService, Xs2aPisCommonPaymentService pisCommonPaymentService, AuthorisationMethodDecider authorisationMethodDecider, PisScaAuthorisationService pisScaAuthorisationService, PisAspspDataService pisAspspDataService, Xs2aPisCommonPaymentMapper xs2aPisCommonPaymentMapper, Xs2aToCmsPisCommonPaymentRequestMapper xs2aToCmsPisCommonPaymentRequestMapper) {
        this.scaPaymentService = scaPaymentService;
        this.pisCommonPaymentService = pisCommonPaymentService;
        this.authorisationMethodDecider = authorisationMethodDecider;
        this.pisScaAuthorisationService = pisScaAuthorisationService;
        this.pisAspspDataService = pisAspspDataService;
        this.xs2aPisCommonPaymentMapper = xs2aPisCommonPaymentMapper;
        this.xs2aToCmsPisCommonPaymentRequestMapper = xs2aToCmsPisCommonPaymentRequestMapper;
    }
}

