/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.service.payment;

import de.adorsys.psd2.xs2a.core.consent.AspspConsentData;
import de.adorsys.psd2.xs2a.core.pis.TransactionStatus;
import de.adorsys.psd2.xs2a.core.psu.PsuIdData;
import de.adorsys.psd2.xs2a.domain.MessageErrorCode;
import de.adorsys.psd2.xs2a.domain.ResponseObject;
import de.adorsys.psd2.xs2a.domain.pis.CancelPaymentResponse;
import de.adorsys.psd2.xs2a.exception.MessageError;
import de.adorsys.psd2.xs2a.service.consent.PisAspspDataService;
import de.adorsys.psd2.xs2a.service.context.SpiContextDataProvider;
import de.adorsys.psd2.xs2a.service.mapper.spi_xs2a_mappers.SpiToXs2aCancelPaymentMapper;
import de.adorsys.psd2.xs2a.spi.domain.SpiContextData;
import de.adorsys.psd2.xs2a.spi.domain.payment.response.SpiPaymentCancellationResponse;
import de.adorsys.psd2.xs2a.spi.domain.response.SpiResponse;
import de.adorsys.psd2.xs2a.spi.service.PaymentCancellationSpi;
import de.adorsys.psd2.xs2a.spi.service.SpiPayment;
import java.beans.ConstructorProperties;
import java.util.Optional;
import org.springframework.stereotype.Service;

@Service
public class CancelPaymentService {
    private final PaymentCancellationSpi paymentCancellationSpi;
    private final SpiToXs2aCancelPaymentMapper spiToXs2aCancelPaymentMapper;
    private final PisAspspDataService pisAspspDataService;
    private final SpiContextDataProvider spiContextDataProvider;

    public ResponseObject<CancelPaymentResponse> cancelPaymentWithoutAuthorisation(PsuIdData psuData, SpiPayment payment, String encryptedPaymentId) {
        SpiContextData spiContextData = this.spiContextDataProvider.provideWithPsuIdData(psuData);
        AspspConsentData aspspConsentData = this.pisAspspDataService.getAspspConsentData(encryptedPaymentId);
        SpiResponse spiResponse = this.paymentCancellationSpi.cancelPaymentWithoutSca(spiContextData, payment, aspspConsentData);
        this.pisAspspDataService.updateAspspConsentData(spiResponse.getAspspConsentData());
        if (spiResponse.hasError()) {
            return ResponseObject.builder().fail(new MessageError(MessageErrorCode.RESOURCE_UNKNOWN_403)).build();
        }
        CancelPaymentResponse cancelPaymentResponse = new CancelPaymentResponse();
        cancelPaymentResponse.setTransactionStatus(TransactionStatus.CANC);
        return ResponseObject.builder().body(cancelPaymentResponse).build();
    }

    public ResponseObject<CancelPaymentResponse> initiatePaymentCancellation(PsuIdData psuData, SpiPayment payment, String encryptedPaymentId) {
        SpiContextData spiContextData = this.spiContextDataProvider.provideWithPsuIdData(psuData);
        AspspConsentData aspspConsentData = this.pisAspspDataService.getAspspConsentData(encryptedPaymentId);
        SpiResponse spiResponse = this.paymentCancellationSpi.initiatePaymentCancellation(spiContextData, payment, aspspConsentData);
        this.pisAspspDataService.updateAspspConsentData(spiResponse.getAspspConsentData());
        if (spiResponse.hasError()) {
            return ResponseObject.builder().fail(new MessageError(MessageErrorCode.RESOURCE_UNKNOWN_403)).build();
        }
        CancelPaymentResponse cancelPaymentResponse = this.spiToXs2aCancelPaymentMapper.mapToCancelPaymentResponse((SpiPaymentCancellationResponse)spiResponse.getPayload());
        return Optional.ofNullable(cancelPaymentResponse).map(p -> ResponseObject.builder().body((CancelPaymentResponse)p).build()).orElseGet(ResponseObject.builder().fail(new MessageError(MessageErrorCode.RESOURCE_UNKNOWN_403))::build);
    }

    @ConstructorProperties(value={"paymentCancellationSpi", "spiToXs2aCancelPaymentMapper", "pisAspspDataService", "spiContextDataProvider"})
    public CancelPaymentService(PaymentCancellationSpi paymentCancellationSpi, SpiToXs2aCancelPaymentMapper spiToXs2aCancelPaymentMapper, PisAspspDataService pisAspspDataService, SpiContextDataProvider spiContextDataProvider) {
        this.paymentCancellationSpi = paymentCancellationSpi;
        this.spiToXs2aCancelPaymentMapper = spiToXs2aCancelPaymentMapper;
        this.pisAspspDataService = pisAspspDataService;
        this.spiContextDataProvider = spiContextDataProvider;
    }
}

