/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.service.mapper.spi_xs2a_mappers;

import de.adorsys.psd2.xs2a.domain.pis.SinglePayment;
import de.adorsys.psd2.xs2a.service.mapper.spi_xs2a_mappers.Xs2aToSpiAccountReferenceMapper;
import de.adorsys.psd2.xs2a.service.mapper.spi_xs2a_mappers.Xs2aToSpiAddressMapper;
import de.adorsys.psd2.xs2a.service.mapper.spi_xs2a_mappers.Xs2aToSpiAmountMapper;
import de.adorsys.psd2.xs2a.spi.domain.payment.SpiSinglePayment;
import java.beans.ConstructorProperties;
import org.springframework.stereotype.Component;

@Component
public class Xs2aToSpiSinglePaymentMapper {
    private final Xs2aToSpiAmountMapper xs2aToSpiAmountMapper;
    private final Xs2aToSpiAddressMapper xs2aToSpiAddressMapper;
    private final Xs2aToSpiAccountReferenceMapper xs2aToSpiAccountReferenceMapper;

    public SpiSinglePayment mapToSpiSinglePayment(SinglePayment payment, String paymentProduct) {
        SpiSinglePayment single = new SpiSinglePayment(paymentProduct);
        single.setPaymentId(payment.getPaymentId());
        single.setEndToEndIdentification(payment.getEndToEndIdentification());
        single.setDebtorAccount(this.xs2aToSpiAccountReferenceMapper.mapToSpiAccountReference(payment.getDebtorAccount()));
        single.setInstructedAmount(this.xs2aToSpiAmountMapper.mapToSpiAmount(payment.getInstructedAmount()));
        single.setCreditorAccount(this.xs2aToSpiAccountReferenceMapper.mapToSpiAccountReference(payment.getCreditorAccount()));
        single.setCreditorAgent(payment.getCreditorAgent());
        single.setCreditorName(payment.getCreditorName());
        single.setCreditorAddress(this.xs2aToSpiAddressMapper.mapToSpiAddress(payment.getCreditorAddress()));
        single.setRemittanceInformationUnstructured(payment.getRemittanceInformationUnstructured());
        single.setRequestedExecutionTime(payment.getRequestedExecutionTime());
        single.setRequestedExecutionDate(payment.getRequestedExecutionDate());
        return single;
    }

    @ConstructorProperties(value={"xs2aToSpiAmountMapper", "xs2aToSpiAddressMapper", "xs2aToSpiAccountReferenceMapper"})
    public Xs2aToSpiSinglePaymentMapper(Xs2aToSpiAmountMapper xs2aToSpiAmountMapper, Xs2aToSpiAddressMapper xs2aToSpiAddressMapper, Xs2aToSpiAccountReferenceMapper xs2aToSpiAccountReferenceMapper) {
        this.xs2aToSpiAmountMapper = xs2aToSpiAmountMapper;
        this.xs2aToSpiAddressMapper = xs2aToSpiAddressMapper;
        this.xs2aToSpiAccountReferenceMapper = xs2aToSpiAccountReferenceMapper;
    }
}

