/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.service.mapper.spi_xs2a_mappers;

import de.adorsys.psd2.xs2a.core.consent.AspspConsentData;
import de.adorsys.psd2.xs2a.core.pis.TransactionStatus;
import de.adorsys.psd2.xs2a.core.profile.PaymentType;
import de.adorsys.psd2.xs2a.domain.pis.CommonPaymentInitiationResponse;
import de.adorsys.psd2.xs2a.domain.pis.PaymentInitiationResponse;
import de.adorsys.psd2.xs2a.spi.domain.payment.response.SpiPaymentInitiationResponse;
import java.util.function.Supplier;
import org.springframework.stereotype.Component;

@Component
public class SpiToXs2aPaymentMapper {
    public <T extends SpiPaymentInitiationResponse, R extends PaymentInitiationResponse> R mapToPaymentInitiateResponse(T spi, Supplier<R> xs2a, AspspConsentData aspspConsentData) {
        PaymentInitiationResponse response = (PaymentInitiationResponse)xs2a.get();
        response.setPaymentId(spi.getPaymentId());
        response.setTransactionStatus(TransactionStatus.getByValue((String)spi.getTransactionStatus().getName()));
        response.setAspspConsentData(aspspConsentData);
        response.setAspspAccountId(spi.getAspspAccountId());
        return (R)response;
    }

    public CommonPaymentInitiationResponse mapToCommonPaymentInitiateResponse(SpiPaymentInitiationResponse spiResponse, PaymentType type, AspspConsentData aspspConsentData) {
        CommonPaymentInitiationResponse commonPaymentInitiationResponse = new CommonPaymentInitiationResponse();
        commonPaymentInitiationResponse.setPaymentType(type);
        commonPaymentInitiationResponse.setPaymentId(spiResponse.getPaymentId());
        commonPaymentInitiationResponse.setTransactionStatus(TransactionStatus.getByValue((String)spiResponse.getTransactionStatus().getName()));
        commonPaymentInitiationResponse.setAspspConsentData(aspspConsentData);
        commonPaymentInitiationResponse.setAspspAccountId(spiResponse.getAspspAccountId());
        return commonPaymentInitiationResponse;
    }
}

