/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.service.mapper.spi_xs2a_mappers;

import de.adorsys.psd2.xs2a.domain.BalanceType;
import de.adorsys.psd2.xs2a.domain.Xs2aBalance;
import de.adorsys.psd2.xs2a.service.mapper.spi_xs2a_mappers.SpiToXs2aAmountMapper;
import de.adorsys.psd2.xs2a.spi.domain.account.SpiAccountBalance;
import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class SpiToXs2aBalanceMapper {
    private final SpiToXs2aAmountMapper amountMapper;

    public Xs2aBalance mapToXs2aBalance(SpiAccountBalance spiAccountBalance) {
        return Optional.ofNullable(spiAccountBalance).map(b -> {
            Xs2aBalance balance = new Xs2aBalance();
            balance.setBalanceAmount(this.amountMapper.mapToXs2aAmount(spiAccountBalance.getSpiBalanceAmount()));
            balance.setBalanceType(BalanceType.valueOf(spiAccountBalance.getSpiBalanceType().name()));
            balance.setLastChangeDateTime(spiAccountBalance.getLastChangeDateTime());
            balance.setReferenceDate(spiAccountBalance.getReferenceDate());
            balance.setLastCommittedTransaction(spiAccountBalance.getLastCommittedTransaction());
            return balance;
        }).orElse(null);
    }

    public List<Xs2aBalance> mapToXs2aBalanceList(List<SpiAccountBalance> spiBalances) {
        if (CollectionUtils.isEmpty(spiBalances)) {
            return new ArrayList<Xs2aBalance>();
        }
        return spiBalances.stream().map(this::mapToXs2aBalance).collect(Collectors.toList());
    }

    @ConstructorProperties(value={"amountMapper"})
    public SpiToXs2aBalanceMapper(SpiToXs2aAmountMapper amountMapper) {
        this.amountMapper = amountMapper;
    }
}

