/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.service.mapper;

import de.adorsys.psd2.xs2a.domain.CustomContentTypeProvider;
import de.adorsys.psd2.xs2a.domain.ResponseObject;
import de.adorsys.psd2.xs2a.exception.MessageError;
import de.adorsys.psd2.xs2a.service.mapper.MessageErrorMapper;
import java.beans.ConstructorProperties;
import java.util.function.Function;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;

@Component
public class ResponseMapper {
    private final MessageErrorMapper messageErrorMapper;

    public <T, R> ResponseEntity<?> ok(ResponseObject<T> response, Function<T, R> mapper) {
        return this.generateResponse(response, HttpStatus.OK, mapper);
    }

    public <T, R> ResponseEntity<?> created(ResponseObject<T> response, Function<T, R> mapper) {
        return this.generateResponse(response, HttpStatus.CREATED, mapper);
    }

    public <T, R> ResponseEntity<?> delete(ResponseObject<T> response, Function<T, R> mapper) {
        return this.generateResponse(response, HttpStatus.NO_CONTENT, mapper);
    }

    public <T> ResponseEntity ok(ResponseObject<T> response) {
        return this.generateResponse(response, HttpStatus.OK);
    }

    public <T> ResponseEntity created(ResponseObject<T> response) {
        return this.generateResponse(response, HttpStatus.CREATED);
    }

    public <T> ResponseEntity delete(ResponseObject<T> response) {
        return this.generateResponse(response, HttpStatus.NO_CONTENT);
    }

    public <T> ResponseEntity accepted(ResponseObject<T> response) {
        return this.generateResponse(response, HttpStatus.ACCEPTED);
    }

    private <T> ResponseEntity generateResponse(ResponseObject<T> response, HttpStatus positiveStatus) {
        return this.generateResponse(response, positiveStatus, null);
    }

    private <T, R> ResponseEntity generateResponse(ResponseObject<T> response, HttpStatus positiveStatus, Function<T, R> mapper) {
        if (response.hasError()) {
            return this.createErrorResponse(response.getError());
        }
        T body = response.getBody();
        ResponseEntity.BodyBuilder responseBuilder = ResponseEntity.status((HttpStatus)positiveStatus);
        if (body instanceof CustomContentTypeProvider) {
            responseBuilder = responseBuilder.contentType(((CustomContentTypeProvider)body).getCustomContentType());
        }
        return responseBuilder.body(this.getBody(body, mapper));
    }

    private <T, R> Object getBody(T body, Function<T, R> mapper) {
        return mapper == null ? body : mapper.apply(body);
    }

    private ResponseEntity createErrorResponse(MessageError error) {
        return new ResponseEntity((Object)this.messageErrorMapper.mapToTppMessage(error), HttpStatus.valueOf((int)error.getTppMessage().getMessageErrorCode().getCode()));
    }

    @ConstructorProperties(value={"messageErrorMapper"})
    public ResponseMapper(MessageErrorMapper messageErrorMapper) {
        this.messageErrorMapper = messageErrorMapper;
    }
}

