/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.service.mapper;

import de.adorsys.psd2.model.MessageCode2XX;
import de.adorsys.psd2.model.TppMessage2XX;
import de.adorsys.psd2.model.TppMessageCategory;
import de.adorsys.psd2.xs2a.domain.MessageErrorCode;
import de.adorsys.psd2.xs2a.exception.MessageError;
import de.adorsys.psd2.xs2a.service.message.MessageService;
import java.beans.ConstructorProperties;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

public class MessageErrorMapper {
    private final MessageService messageService;

    public List<TppMessage2XX> mapToTppMessages(MessageErrorCode ... errorCodes) {
        return Optional.ofNullable(errorCodes).map(m -> Arrays.stream(m).map(this::getTppMessage2XX).collect(Collectors.toList())).orElse(Collections.emptyList());
    }

    public TppMessage2XX mapToTppMessage(MessageError error) {
        return Optional.ofNullable(error).map(e -> e.getTppMessage().getMessageErrorCode()).map(this::getTppMessage2XX).orElseGet(TppMessage2XX::new);
    }

    private TppMessage2XX getTppMessage2XX(MessageErrorCode code) {
        TppMessage2XX tppMessage2XX = new TppMessage2XX();
        tppMessage2XX.setCategory(TppMessageCategory.ERROR);
        tppMessage2XX.setCode(MessageCode2XX.WARNING);
        tppMessage2XX.setPath("N/A");
        tppMessage2XX.setText(this.messageService.getMessage(code.name()));
        return tppMessage2XX;
    }

    @ConstructorProperties(value={"messageService"})
    public MessageErrorMapper(MessageService messageService) {
        this.messageService = messageService;
    }
}

