/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.service.mapper;

import com.fasterxml.jackson.databind.ObjectMapper;
import de.adorsys.psd2.model.ConfirmationOfFunds;
import de.adorsys.psd2.xs2a.core.profile.AccountReference;
import de.adorsys.psd2.xs2a.domain.fund.FundsConfirmationRequest;
import de.adorsys.psd2.xs2a.service.mapper.AmountModelMapper;
import java.beans.ConstructorProperties;
import java.util.Optional;
import org.springframework.stereotype.Component;

@Component
public class FundsConfirmationModelMapper {
    private final ObjectMapper objectMapper;
    private final AmountModelMapper amountModelMapper;

    public FundsConfirmationRequest mapToFundsConfirmationRequest(ConfirmationOfFunds confirmationOfFunds) {
        return Optional.ofNullable(confirmationOfFunds).map(conf -> {
            FundsConfirmationRequest fundsConfirmationRequest = new FundsConfirmationRequest();
            fundsConfirmationRequest.setCardNumber(conf.getCardNumber());
            fundsConfirmationRequest.setPayee(conf.getPayee());
            fundsConfirmationRequest.setPsuAccount(this.mapToAccountReferenceInner(conf.getAccount()));
            fundsConfirmationRequest.setInstructedAmount(this.amountModelMapper.mapToXs2aAmount(conf.getInstructedAmount()));
            return fundsConfirmationRequest;
        }).orElse(null);
    }

    private AccountReference mapToAccountReferenceInner(Object reference) {
        return (AccountReference)this.objectMapper.convertValue(reference, AccountReference.class);
    }

    @ConstructorProperties(value={"objectMapper", "amountModelMapper"})
    public FundsConfirmationModelMapper(ObjectMapper objectMapper, AmountModelMapper amountModelMapper) {
        this.objectMapper = objectMapper;
        this.amountModelMapper = amountModelMapper;
    }
}

