/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.service.consent;

import de.adorsys.psd2.xs2a.core.profile.AccountReference;
import de.adorsys.psd2.xs2a.domain.account.Xs2aAccountDetails;
import de.adorsys.psd2.xs2a.domain.consent.Xs2aAccountAccess;
import de.adorsys.psd2.xs2a.service.consent.Xs2aAisConsentService;
import de.adorsys.psd2.xs2a.service.mapper.consent.Xs2aAisConsentMapper;
import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.springframework.stereotype.Service;

@Service
public class AccountReferenceInConsentUpdater {
    private final Xs2aAisConsentService aisConsentService;
    private final Xs2aAisConsentMapper consentMapper;

    public void rewriteAccountAccess(@NotNull String consentId, @NotNull Xs2aAccountAccess newAccountAccess) {
        this.aisConsentService.updateAspspAccountAccess(consentId, this.consentMapper.mapToAisAccountAccessInfo(newAccountAccess));
    }

    public void updateAccountReferences(@NotNull String consentId, @NotNull List<Xs2aAccountDetails> accountDetails) {
        ArrayList<AccountReference> accounts = new ArrayList<AccountReference>();
        ArrayList<AccountReference> transactions = new ArrayList<AccountReference>();
        ArrayList<AccountReference> balances = new ArrayList<AccountReference>();
        for (Xs2aAccountDetails accountDetail : accountDetails) {
            AccountReference reference = new AccountReference(accountDetail.getAccountSelector().getAccountReferenceType(), accountDetail.getAccountReferenceValue(), accountDetail.getCurrency(), accountDetail.getResourceId(), accountDetail.getAspspAccountId());
            accounts.add(reference);
            transactions.add(reference);
            balances.add(reference);
        }
        Xs2aAccountAccess xs2aAccountAccess = new Xs2aAccountAccess(accounts, balances, transactions, null, null);
        this.aisConsentService.updateAspspAccountAccess(consentId, this.consentMapper.mapToAisAccountAccessInfo(xs2aAccountAccess));
    }

    @ConstructorProperties(value={"aisConsentService", "consentMapper"})
    public AccountReferenceInConsentUpdater(Xs2aAisConsentService aisConsentService, Xs2aAisConsentMapper consentMapper) {
        this.aisConsentService = aisConsentService;
        this.consentMapper = consentMapper;
    }
}

