/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.service.authorization.ais.stage;

import de.adorsys.psd2.xs2a.core.sca.ScaStatus;
import de.adorsys.psd2.xs2a.domain.MessageErrorCode;
import de.adorsys.psd2.xs2a.domain.consent.UpdateConsentPsuDataResponse;
import de.adorsys.psd2.xs2a.service.consent.AisConsentDataService;
import de.adorsys.psd2.xs2a.service.consent.Xs2aAisConsentService;
import de.adorsys.psd2.xs2a.service.mapper.consent.Xs2aAisConsentMapper;
import de.adorsys.psd2.xs2a.service.mapper.spi_xs2a_mappers.SpiResponseStatusToXs2aMessageErrorCodeMapper;
import de.adorsys.psd2.xs2a.service.mapper.spi_xs2a_mappers.SpiToXs2aAuthenticationObjectMapper;
import de.adorsys.psd2.xs2a.service.mapper.spi_xs2a_mappers.Xs2aToSpiPsuDataMapper;
import de.adorsys.psd2.xs2a.spi.service.AisConsentSpi;
import java.beans.ConstructorProperties;
import java.util.List;
import java.util.function.Function;

public abstract class AisScaStage<T, R>
implements Function<T, R> {
    protected final Xs2aAisConsentService aisConsentService;
    protected final AisConsentDataService aisConsentDataService;
    protected final AisConsentSpi aisConsentSpi;
    protected final Xs2aAisConsentMapper aisConsentMapper;
    protected final SpiResponseStatusToXs2aMessageErrorCodeMapper messageErrorCodeMapper;
    protected final Xs2aToSpiPsuDataMapper psuDataMapper;
    protected final SpiToXs2aAuthenticationObjectMapper spiToXs2aAuthenticationObjectMapper;

    UpdateConsentPsuDataResponse createFailedResponse(MessageErrorCode errorCode, List<String> messages) {
        UpdateConsentPsuDataResponse response = new UpdateConsentPsuDataResponse();
        response.setErrorCode(errorCode);
        response.setScaStatus(ScaStatus.FAILED);
        response.setPsuMessage(this.buildPsuMessage(messages));
        return response;
    }

    private String buildPsuMessage(List<String> messages) {
        return String.join((CharSequence)", ", messages);
    }

    @ConstructorProperties(value={"aisConsentService", "aisConsentDataService", "aisConsentSpi", "aisConsentMapper", "messageErrorCodeMapper", "psuDataMapper", "spiToXs2aAuthenticationObjectMapper"})
    public AisScaStage(Xs2aAisConsentService aisConsentService, AisConsentDataService aisConsentDataService, AisConsentSpi aisConsentSpi, Xs2aAisConsentMapper aisConsentMapper, SpiResponseStatusToXs2aMessageErrorCodeMapper messageErrorCodeMapper, Xs2aToSpiPsuDataMapper psuDataMapper, SpiToXs2aAuthenticationObjectMapper spiToXs2aAuthenticationObjectMapper) {
        this.aisConsentService = aisConsentService;
        this.aisConsentDataService = aisConsentDataService;
        this.aisConsentSpi = aisConsentSpi;
        this.aisConsentMapper = aisConsentMapper;
        this.messageErrorCodeMapper = messageErrorCodeMapper;
        this.psuDataMapper = psuDataMapper;
        this.spiToXs2aAuthenticationObjectMapper = spiToXs2aAuthenticationObjectMapper;
    }
}

