/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.service;

import de.adorsys.psd2.consent.api.pis.PisPayment;
import de.adorsys.psd2.consent.api.pis.proto.PisCommonPaymentResponse;
import de.adorsys.psd2.xs2a.config.factory.ReadPaymentFactory;
import de.adorsys.psd2.xs2a.config.factory.ReadPaymentStatusFactory;
import de.adorsys.psd2.xs2a.core.consent.AspspConsentData;
import de.adorsys.psd2.xs2a.core.event.EventType;
import de.adorsys.psd2.xs2a.core.pis.TransactionStatus;
import de.adorsys.psd2.xs2a.core.profile.PaymentType;
import de.adorsys.psd2.xs2a.core.psu.PsuIdData;
import de.adorsys.psd2.xs2a.core.tpp.TppInfo;
import de.adorsys.psd2.xs2a.domain.ErrorHolder;
import de.adorsys.psd2.xs2a.domain.MessageErrorCode;
import de.adorsys.psd2.xs2a.domain.ResponseObject;
import de.adorsys.psd2.xs2a.domain.pis.BulkPayment;
import de.adorsys.psd2.xs2a.domain.pis.CancelPaymentResponse;
import de.adorsys.psd2.xs2a.domain.pis.CommonPayment;
import de.adorsys.psd2.xs2a.domain.pis.PaymentInformationResponse;
import de.adorsys.psd2.xs2a.domain.pis.PaymentInitiationParameters;
import de.adorsys.psd2.xs2a.domain.pis.PeriodicPayment;
import de.adorsys.psd2.xs2a.domain.pis.SinglePayment;
import de.adorsys.psd2.xs2a.exception.MessageError;
import de.adorsys.psd2.xs2a.service.TppService;
import de.adorsys.psd2.xs2a.service.consent.PisAspspDataService;
import de.adorsys.psd2.xs2a.service.consent.PisPsuDataService;
import de.adorsys.psd2.xs2a.service.consent.Xs2aPisCommonPaymentService;
import de.adorsys.psd2.xs2a.service.context.SpiContextDataProvider;
import de.adorsys.psd2.xs2a.service.event.Xs2aEventService;
import de.adorsys.psd2.xs2a.service.mapper.consent.CmsToXs2aPaymentMapper;
import de.adorsys.psd2.xs2a.service.mapper.spi_xs2a_mappers.SpiErrorMapper;
import de.adorsys.psd2.xs2a.service.mapper.spi_xs2a_mappers.SpiToXs2aTransactionalStatusMapper;
import de.adorsys.psd2.xs2a.service.mapper.spi_xs2a_mappers.Xs2aToSpiPaymentInfoMapper;
import de.adorsys.psd2.xs2a.service.payment.CancelPaymentService;
import de.adorsys.psd2.xs2a.service.payment.CreateBulkPaymentService;
import de.adorsys.psd2.xs2a.service.payment.CreateCommonPaymentService;
import de.adorsys.psd2.xs2a.service.payment.CreatePeriodicPaymentService;
import de.adorsys.psd2.xs2a.service.payment.CreateSinglePaymentService;
import de.adorsys.psd2.xs2a.service.payment.ReadCommonPaymentService;
import de.adorsys.psd2.xs2a.service.payment.ReadPaymentService;
import de.adorsys.psd2.xs2a.service.payment.ReadPaymentStatusService;
import de.adorsys.psd2.xs2a.service.payment.SpiPaymentFactory;
import de.adorsys.psd2.xs2a.service.payment.Xs2aUpdatePaymentStatusAfterSpiService;
import de.adorsys.psd2.xs2a.service.profile.AspspProfileServiceWrapper;
import de.adorsys.psd2.xs2a.spi.domain.SpiContextData;
import de.adorsys.psd2.xs2a.spi.domain.common.SpiTransactionStatus;
import de.adorsys.psd2.xs2a.spi.domain.payment.SpiPaymentInfo;
import de.adorsys.psd2.xs2a.spi.domain.response.SpiResponse;
import de.adorsys.psd2.xs2a.spi.service.CommonPaymentSpi;
import de.adorsys.psd2.xs2a.spi.service.SpiPayment;
import java.beans.ConstructorProperties;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class PaymentService {
    private static final Logger log = LoggerFactory.getLogger(PaymentService.class);
    private final ReadPaymentFactory readPaymentFactory;
    private final ReadPaymentStatusFactory readPaymentStatusFactory;
    private final SpiPaymentFactory spiPaymentFactory;
    private final Xs2aPisCommonPaymentService pisCommonPaymentService;
    private final Xs2aUpdatePaymentStatusAfterSpiService updatePaymentStatusAfterSpiService;
    private final PisAspspDataService pisAspspDataService;
    private final PisPsuDataService pisPsuDataService;
    private final TppService tppService;
    private final CreateSinglePaymentService createSinglePaymentService;
    private final CreatePeriodicPaymentService createPeriodicPaymentService;
    private final CreateBulkPaymentService createBulkPaymentService;
    private final CommonPaymentSpi commonPaymentSpi;
    private final SpiToXs2aTransactionalStatusMapper spiToXs2aTransactionalStatus;
    private final AspspProfileServiceWrapper profileService;
    private final CancelPaymentService cancelPaymentService;
    private final SpiErrorMapper spiErrorMapper;
    private final Xs2aEventService xs2aEventService;
    private final CreateCommonPaymentService createCommonPaymentService;
    private final ReadCommonPaymentService readCommonPaymentService;
    private final Xs2aToSpiPaymentInfoMapper xs2aToSpiPaymentInfoMapper;
    private final CmsToXs2aPaymentMapper cmsToXs2aPaymentMapper;
    private final SpiContextDataProvider spiContextDataProvider;

    public ResponseObject createPayment(Object payment, PaymentInitiationParameters paymentInitiationParameters) {
        this.xs2aEventService.recordTppRequest(EventType.PAYMENT_INITIATION_REQUEST_RECEIVED, payment);
        TppInfo tppInfo = this.tppService.getTppInfo();
        tppInfo.setTppRedirectUri(paymentInitiationParameters.getTppRedirectUri());
        if (this.isRawPaymentProduct(paymentInitiationParameters.getPaymentProduct())) {
            CommonPayment request = new CommonPayment();
            request.setPaymentType(paymentInitiationParameters.getPaymentType());
            request.setPaymentProduct(paymentInitiationParameters.getPaymentProduct());
            request.setPaymentData((byte[])payment);
            request.setTppInfo(tppInfo);
            request.setPsuDataList(Collections.singletonList(paymentInitiationParameters.getPsuData()));
            return this.createCommonPaymentService.createPayment(request, paymentInitiationParameters, tppInfo);
        }
        if (paymentInitiationParameters.getPaymentType() == PaymentType.SINGLE) {
            return this.createSinglePaymentService.createPayment((SinglePayment)payment, paymentInitiationParameters, tppInfo);
        }
        if (paymentInitiationParameters.getPaymentType() == PaymentType.PERIODIC) {
            return this.createPeriodicPaymentService.createPayment((PeriodicPayment)payment, paymentInitiationParameters, tppInfo);
        }
        return this.createBulkPaymentService.createPayment((BulkPayment)payment, paymentInitiationParameters, tppInfo);
    }

    private boolean isRawPaymentProduct(String paymentProduct) {
        return paymentProduct.contains("pain.");
    }

    public ResponseObject getPaymentById(PaymentType paymentType, String paymentId) {
        PaymentInformationResponse response;
        this.xs2aEventService.recordPisTppRequest(paymentId, EventType.GET_PAYMENT_REQUEST_RECEIVED);
        Optional<PisCommonPaymentResponse> pisCommonPaymentOptional = this.pisCommonPaymentService.getPisCommonPaymentById(paymentId);
        if (!pisCommonPaymentOptional.isPresent()) {
            return ResponseObject.builder().fail(new MessageError(MessageErrorCode.RESOURCE_UNKNOWN_403)).build();
        }
        PisCommonPaymentResponse commonPaymentResponse = pisCommonPaymentOptional.get();
        CommonPayment commonPayment = this.cmsToXs2aPaymentMapper.mapToXs2aCommonPayment(commonPaymentResponse);
        AspspConsentData aspspConsentData = this.pisAspspDataService.getAspspConsentData(paymentId);
        if (commonPayment.getPaymentData() != null) {
            response = this.readCommonPaymentService.getPayment(commonPayment, this.readPsuIdDataFromList(commonPayment.getPsuDataList()), aspspConsentData);
        } else {
            List<PisPayment> pisPayments = this.getPisPaymentFromCommonPaymentResponse(commonPaymentResponse);
            if (CollectionUtils.isEmpty(pisPayments)) {
                return ResponseObject.builder().fail(new MessageError(MessageErrorCode.FORMAT_ERROR, "Payment not found")).build();
            }
            ReadPaymentService readPaymentService = (ReadPaymentService)this.readPaymentFactory.getService(paymentType.getValue());
            response = (PaymentInformationResponse)readPaymentService.getPayment(pisPayments, commonPaymentResponse.getPaymentProduct(), this.readPsuIdDataFromList(commonPayment.getPsuDataList()), aspspConsentData);
        }
        if (response.hasError()) {
            return ResponseObject.builder().fail(new MessageError(response.getErrorHolder().getErrorCode(), response.getErrorHolder().getMessage())).build();
        }
        return ResponseObject.builder().body(response.getPayment()).build();
    }

    public ResponseObject<TransactionStatus> getPaymentStatusById(PaymentType paymentType, String paymentId) {
        SpiResponse<SpiTransactionStatus> spiResponse;
        this.xs2aEventService.recordPisTppRequest(paymentId, EventType.GET_TRANSACTION_STATUS_REQUEST_RECEIVED);
        Optional<PisCommonPaymentResponse> pisCommonPaymentOptional = this.pisCommonPaymentService.getPisCommonPaymentById(paymentId);
        if (!pisCommonPaymentOptional.isPresent()) {
            return ResponseObject.builder().fail(new MessageError(MessageErrorCode.FORMAT_ERROR, "Payment not found")).build();
        }
        PisCommonPaymentResponse pisCommonPaymentResponse = pisCommonPaymentOptional.get();
        if (pisCommonPaymentResponse.getTransactionStatus() == TransactionStatus.RJCT) {
            return ResponseObject.builder().body(TransactionStatus.RJCT).build();
        }
        AspspConsentData aspspConsentData = this.pisAspspDataService.getAspspConsentData(paymentId);
        List<PsuIdData> psuData = this.pisPsuDataService.getPsuDataByPaymentId(paymentId);
        SpiContextData spiContextData = this.spiContextDataProvider.provideWithPsuIdData(this.readPsuIdDataFromList(psuData));
        if (pisCommonPaymentResponse.getPaymentData() != null) {
            CommonPayment commonPayment = this.cmsToXs2aPaymentMapper.mapToXs2aCommonPayment(pisCommonPaymentResponse);
            SpiPaymentInfo request = this.xs2aToSpiPaymentInfoMapper.mapToSpiPaymentInfo(commonPayment);
            spiResponse = this.commonPaymentSpi.getPaymentStatusById(spiContextData, request, aspspConsentData);
        } else {
            List<PisPayment> pisPayments = this.getPisPaymentFromCommonPaymentResponse(pisCommonPaymentResponse);
            if (CollectionUtils.isEmpty(pisPayments)) {
                return ResponseObject.builder().fail(new MessageError(MessageErrorCode.FORMAT_ERROR, "Payment not found")).build();
            }
            ReadPaymentStatusService readPaymentStatusService = (ReadPaymentStatusService)this.readPaymentStatusFactory.getService("status-" + paymentType.getValue());
            spiResponse = readPaymentStatusService.readPaymentStatus(pisPayments, pisCommonPaymentResponse.getPaymentProduct(), spiContextData, aspspConsentData);
        }
        this.pisAspspDataService.updateAspspConsentData(spiResponse.getAspspConsentData());
        if (spiResponse.hasError()) {
            ErrorHolder errorHolder = this.spiErrorMapper.mapToErrorHolder(spiResponse);
            return ResponseObject.builder().fail(new MessageError(errorHolder.getErrorCode(), errorHolder.getMessage())).build();
        }
        TransactionStatus transactionStatus = this.spiToXs2aTransactionalStatus.mapToTransactionStatus((SpiTransactionStatus)spiResponse.getPayload());
        if (transactionStatus == null) {
            return ResponseObject.builder().fail(new MessageError(MessageErrorCode.RESOURCE_UNKNOWN_403)).build();
        }
        if (!this.updatePaymentStatusAfterSpiService.updatePaymentStatus(paymentId, transactionStatus)) {
            return ResponseObject.builder().fail(new MessageError(MessageErrorCode.FORMAT_ERROR, "Payment is finalised already, so its status cannot be changed")).build();
        }
        return ResponseObject.builder().body(transactionStatus).build();
    }

    public ResponseObject<CancelPaymentResponse> cancelPayment(PaymentType paymentType, String encryptedPaymentId) {
        Object commonPayment;
        this.xs2aEventService.recordPisTppRequest(encryptedPaymentId, EventType.PAYMENT_CANCELLATION_REQUEST_RECEIVED);
        Optional<PisCommonPaymentResponse> pisCommonPaymentOptional = this.pisCommonPaymentService.getPisCommonPaymentById(encryptedPaymentId);
        if (!pisCommonPaymentOptional.isPresent()) {
            return ResponseObject.builder().fail(new MessageError(MessageErrorCode.FORMAT_ERROR, "Payment not found")).build();
        }
        PisCommonPaymentResponse pisCommonPaymentResponse = pisCommonPaymentOptional.get();
        SpiPaymentInfo spiPayment = null;
        if (pisCommonPaymentResponse.getPaymentData() != null) {
            commonPayment = this.cmsToXs2aPaymentMapper.mapToXs2aCommonPayment(pisCommonPaymentResponse);
            spiPayment = this.xs2aToSpiPaymentInfoMapper.mapToSpiPaymentInfo((CommonPayment)commonPayment);
        } else {
            List<PisPayment> pisPayments = this.getPisPaymentFromCommonPaymentResponse(pisCommonPaymentResponse);
            if (CollectionUtils.isEmpty(pisPayments)) {
                return ResponseObject.builder().fail(new MessageError(MessageErrorCode.FORMAT_ERROR, "Payment not found")).build();
            }
            Optional<? extends SpiPayment> spiPaymentOptional = this.spiPaymentFactory.createSpiPaymentByPaymentType(pisPayments, pisCommonPaymentResponse.getPaymentProduct(), paymentType);
            if (!spiPaymentOptional.isPresent()) {
                log.error("Unknown payment type: {}", (Object)paymentType);
                return ResponseObject.builder().fail(new MessageError(MessageErrorCode.FORMAT_ERROR)).build();
            }
            spiPayment = spiPaymentOptional.get();
        }
        commonPayment = this.pisCommonPaymentService.getPisCommonPaymentById(encryptedPaymentId);
        if (((Optional)commonPayment).isPresent() && this.isFinalisedPayment((PisCommonPaymentResponse)((Optional)commonPayment).get())) {
            return ResponseObject.builder().fail(new MessageError(MessageErrorCode.FORMAT_ERROR, "Payment is finalised already and cannot be cancelled")).build();
        }
        List<PsuIdData> psuData = this.pisPsuDataService.getPsuDataByPaymentId(encryptedPaymentId);
        if (this.profileService.isPaymentCancellationAuthorizationMandated()) {
            return this.cancelPaymentService.initiatePaymentCancellation(psuData.get(0), (SpiPayment)spiPayment, encryptedPaymentId);
        }
        return this.cancelPaymentService.cancelPaymentWithoutAuthorisation(this.readPsuIdDataFromList(psuData), (SpiPayment)spiPayment, encryptedPaymentId);
    }

    private boolean isFinalisedPayment(PisCommonPaymentResponse response) {
        List finalisedPayments = response.getPayments().stream().filter(p -> p.getTransactionStatus().isFinalisedStatus()).collect(Collectors.toList());
        return CollectionUtils.isNotEmpty(finalisedPayments);
    }

    private List<PisPayment> getPisPaymentFromCommonPaymentResponse(PisCommonPaymentResponse pisCommonPaymentResponse) {
        List<PisPayment> pisPayments = Optional.of(pisCommonPaymentResponse).map(PisCommonPaymentResponse::getPayments).orElse(Collections.emptyList());
        pisPayments.forEach(pmt -> pmt.setPaymentId(pisCommonPaymentResponse.getExternalId()));
        return pisPayments;
    }

    private PsuIdData readPsuIdDataFromList(List<PsuIdData> psuIdDataList) {
        if (CollectionUtils.isNotEmpty(psuIdDataList)) {
            return psuIdDataList.get(0);
        }
        return null;
    }

    @ConstructorProperties(value={"readPaymentFactory", "readPaymentStatusFactory", "spiPaymentFactory", "pisCommonPaymentService", "updatePaymentStatusAfterSpiService", "pisAspspDataService", "pisPsuDataService", "tppService", "createSinglePaymentService", "createPeriodicPaymentService", "createBulkPaymentService", "commonPaymentSpi", "spiToXs2aTransactionalStatus", "profileService", "cancelPaymentService", "spiErrorMapper", "xs2aEventService", "createCommonPaymentService", "readCommonPaymentService", "xs2aToSpiPaymentInfoMapper", "cmsToXs2aPaymentMapper", "spiContextDataProvider"})
    public PaymentService(ReadPaymentFactory readPaymentFactory, ReadPaymentStatusFactory readPaymentStatusFactory, SpiPaymentFactory spiPaymentFactory, Xs2aPisCommonPaymentService pisCommonPaymentService, Xs2aUpdatePaymentStatusAfterSpiService updatePaymentStatusAfterSpiService, PisAspspDataService pisAspspDataService, PisPsuDataService pisPsuDataService, TppService tppService, CreateSinglePaymentService createSinglePaymentService, CreatePeriodicPaymentService createPeriodicPaymentService, CreateBulkPaymentService createBulkPaymentService, CommonPaymentSpi commonPaymentSpi, SpiToXs2aTransactionalStatusMapper spiToXs2aTransactionalStatus, AspspProfileServiceWrapper profileService, CancelPaymentService cancelPaymentService, SpiErrorMapper spiErrorMapper, Xs2aEventService xs2aEventService, CreateCommonPaymentService createCommonPaymentService, ReadCommonPaymentService readCommonPaymentService, Xs2aToSpiPaymentInfoMapper xs2aToSpiPaymentInfoMapper, CmsToXs2aPaymentMapper cmsToXs2aPaymentMapper, SpiContextDataProvider spiContextDataProvider) {
        this.readPaymentFactory = readPaymentFactory;
        this.readPaymentStatusFactory = readPaymentStatusFactory;
        this.spiPaymentFactory = spiPaymentFactory;
        this.pisCommonPaymentService = pisCommonPaymentService;
        this.updatePaymentStatusAfterSpiService = updatePaymentStatusAfterSpiService;
        this.pisAspspDataService = pisAspspDataService;
        this.pisPsuDataService = pisPsuDataService;
        this.tppService = tppService;
        this.createSinglePaymentService = createSinglePaymentService;
        this.createPeriodicPaymentService = createPeriodicPaymentService;
        this.createBulkPaymentService = createBulkPaymentService;
        this.commonPaymentSpi = commonPaymentSpi;
        this.spiToXs2aTransactionalStatus = spiToXs2aTransactionalStatus;
        this.profileService = profileService;
        this.cancelPaymentService = cancelPaymentService;
        this.spiErrorMapper = spiErrorMapper;
        this.xs2aEventService = xs2aEventService;
        this.createCommonPaymentService = createCommonPaymentService;
        this.readCommonPaymentService = readCommonPaymentService;
        this.xs2aToSpiPaymentInfoMapper = xs2aToSpiPaymentInfoMapper;
        this.cmsToXs2aPaymentMapper = cmsToXs2aPaymentMapper;
        this.spiContextDataProvider = spiContextDataProvider;
    }
}

