/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.service;

import de.adorsys.psd2.consent.api.pis.proto.PisCommonPaymentResponse;
import de.adorsys.psd2.xs2a.core.event.EventType;
import de.adorsys.psd2.xs2a.core.pis.TransactionStatus;
import de.adorsys.psd2.xs2a.core.profile.PaymentType;
import de.adorsys.psd2.xs2a.core.psu.PsuIdData;
import de.adorsys.psd2.xs2a.core.sca.ScaStatus;
import de.adorsys.psd2.xs2a.domain.MessageErrorCode;
import de.adorsys.psd2.xs2a.domain.ResponseObject;
import de.adorsys.psd2.xs2a.domain.consent.Xs2aAuthorisationSubResources;
import de.adorsys.psd2.xs2a.domain.consent.Xs2aCreatePisAuthorisationResponse;
import de.adorsys.psd2.xs2a.domain.consent.pis.Xs2aUpdatePisCommonPaymentPsuDataRequest;
import de.adorsys.psd2.xs2a.domain.consent.pis.Xs2aUpdatePisCommonPaymentPsuDataResponse;
import de.adorsys.psd2.xs2a.exception.MessageError;
import de.adorsys.psd2.xs2a.service.PaymentAuthorisationService;
import de.adorsys.psd2.xs2a.service.authorization.pis.PisScaAuthorisationService;
import de.adorsys.psd2.xs2a.service.consent.Xs2aPisCommonPaymentService;
import de.adorsys.psd2.xs2a.service.event.Xs2aEventService;
import java.beans.ConstructorProperties;
import java.util.Optional;
import org.springframework.stereotype.Service;

@Service
public class PaymentAuthorisationServiceImpl
implements PaymentAuthorisationService {
    private final Xs2aEventService xs2aEventService;
    private final PisScaAuthorisationService pisScaAuthorisationService;
    private final Xs2aPisCommonPaymentService pisCommonPaymentService;

    @Override
    public ResponseObject<Xs2aCreatePisAuthorisationResponse> createPisAuthorization(String paymentId, PaymentType paymentType, PsuIdData psuData) {
        this.xs2aEventService.recordPisTppRequest(paymentId, EventType.START_PAYMENT_AUTHORISATION_REQUEST_RECEIVED);
        Optional<PisCommonPaymentResponse> pisCommonPaymentResponse = this.pisCommonPaymentService.getPisCommonPaymentById(paymentId);
        if (pisCommonPaymentResponse.isPresent() && pisCommonPaymentResponse.get().getTransactionStatus() == TransactionStatus.RJCT) {
            return ResponseObject.builder().fail(new MessageError(MessageErrorCode.RESOURCE_EXPIRED_403)).build();
        }
        return this.pisScaAuthorisationService.createCommonPaymentAuthorisation(paymentId, paymentType, psuData).map(resp -> ResponseObject.builder().body((Xs2aCreatePisAuthorisationResponse)resp).build()).orElseGet(ResponseObject.builder().fail(new MessageError(MessageErrorCode.PAYMENT_FAILED))::build);
    }

    @Override
    public ResponseObject<Xs2aUpdatePisCommonPaymentPsuDataResponse> updatePisCommonPaymentPsuData(Xs2aUpdatePisCommonPaymentPsuDataRequest request) {
        this.xs2aEventService.recordPisTppRequest(request.getPaymentId(), EventType.UPDATE_PAYMENT_AUTHORISATION_PSU_DATA_REQUEST_RECEIVED, request);
        Optional<PisCommonPaymentResponse> pisCommonPaymentResponse = this.pisCommonPaymentService.getPisCommonPaymentById(request.getPaymentId());
        if (pisCommonPaymentResponse.isPresent() && pisCommonPaymentResponse.get().getTransactionStatus() == TransactionStatus.RJCT) {
            return ResponseObject.builder().fail(new MessageError(MessageErrorCode.RESOURCE_EXPIRED_403)).build();
        }
        Xs2aUpdatePisCommonPaymentPsuDataResponse response = this.pisScaAuthorisationService.updateCommonPaymentPsuData(request);
        if (response.hasError()) {
            return ResponseObject.builder().fail(new MessageError(response.getErrorHolder().getErrorCode(), response.getErrorHolder().getMessage())).build();
        }
        return ResponseObject.builder().body(response).build();
    }

    @Override
    public ResponseObject<Xs2aAuthorisationSubResources> getPaymentInitiationAuthorisations(String paymentId) {
        this.xs2aEventService.recordPisTppRequest(paymentId, EventType.GET_PAYMENT_AUTHORISATION_REQUEST_RECEIVED);
        return this.pisScaAuthorisationService.getAuthorisationSubResources(paymentId).map(resp -> ResponseObject.builder().body((Xs2aAuthorisationSubResources)resp).build()).orElseGet(ResponseObject.builder().fail(new MessageError(MessageErrorCode.RESOURCE_UNKNOWN_404))::build);
    }

    @Override
    public ResponseObject<ScaStatus> getPaymentInitiationAuthorisationScaStatus(String paymentId, String authorisationId) {
        this.xs2aEventService.recordPisTppRequest(paymentId, EventType.GET_PAYMENT_SCA_STATUS_REQUEST_RECEIVED);
        Optional<ScaStatus> scaStatus = this.pisScaAuthorisationService.getAuthorisationScaStatus(paymentId, authorisationId);
        if (!scaStatus.isPresent()) {
            return ResponseObject.builder().fail(new MessageError(MessageErrorCode.RESOURCE_UNKNOWN_403)).build();
        }
        return ResponseObject.builder().body(scaStatus.get()).build();
    }

    @ConstructorProperties(value={"xs2aEventService", "pisScaAuthorisationService", "pisCommonPaymentService"})
    public PaymentAuthorisationServiceImpl(Xs2aEventService xs2aEventService, PisScaAuthorisationService pisScaAuthorisationService, Xs2aPisCommonPaymentService pisCommonPaymentService) {
        this.xs2aEventService = xs2aEventService;
        this.pisScaAuthorisationService = pisScaAuthorisationService;
        this.pisCommonPaymentService = pisCommonPaymentService;
    }
}

