/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.service;

import de.adorsys.psd2.xs2a.core.consent.ConsentStatus;
import de.adorsys.psd2.xs2a.core.event.EventType;
import de.adorsys.psd2.xs2a.core.profile.AccountReference;
import de.adorsys.psd2.xs2a.core.profile.ScaApproach;
import de.adorsys.psd2.xs2a.core.psu.PsuIdData;
import de.adorsys.psd2.xs2a.core.sca.ScaStatus;
import de.adorsys.psd2.xs2a.core.tpp.TppInfo;
import de.adorsys.psd2.xs2a.core.tpp.TppRedirectUri;
import de.adorsys.psd2.xs2a.domain.MessageErrorCode;
import de.adorsys.psd2.xs2a.domain.ResponseObject;
import de.adorsys.psd2.xs2a.domain.TppMessageInformation;
import de.adorsys.psd2.xs2a.domain.consent.AccountConsent;
import de.adorsys.psd2.xs2a.domain.consent.AccountConsentAuthorization;
import de.adorsys.psd2.xs2a.domain.consent.ConsentStatusResponse;
import de.adorsys.psd2.xs2a.domain.consent.CreateConsentAuthorizationResponse;
import de.adorsys.psd2.xs2a.domain.consent.CreateConsentReq;
import de.adorsys.psd2.xs2a.domain.consent.CreateConsentResponse;
import de.adorsys.psd2.xs2a.domain.consent.UpdateConsentPsuDataReq;
import de.adorsys.psd2.xs2a.domain.consent.UpdateConsentPsuDataResponse;
import de.adorsys.psd2.xs2a.domain.consent.Xs2aAccountAccess;
import de.adorsys.psd2.xs2a.domain.consent.Xs2aAuthorisationSubResources;
import de.adorsys.psd2.xs2a.exception.MessageCategory;
import de.adorsys.psd2.xs2a.exception.MessageError;
import de.adorsys.psd2.xs2a.service.TppService;
import de.adorsys.psd2.xs2a.service.authorization.AuthorisationMethodDecider;
import de.adorsys.psd2.xs2a.service.authorization.ais.AisAuthorizationService;
import de.adorsys.psd2.xs2a.service.consent.AccountReferenceInConsentUpdater;
import de.adorsys.psd2.xs2a.service.consent.AisConsentDataService;
import de.adorsys.psd2.xs2a.service.consent.Xs2aAisConsentService;
import de.adorsys.psd2.xs2a.service.context.SpiContextDataProvider;
import de.adorsys.psd2.xs2a.service.event.Xs2aEventService;
import de.adorsys.psd2.xs2a.service.mapper.consent.Xs2aAisConsentMapper;
import de.adorsys.psd2.xs2a.service.mapper.spi_xs2a_mappers.SpiResponseStatusToXs2aMessageErrorCodeMapper;
import de.adorsys.psd2.xs2a.service.mapper.spi_xs2a_mappers.SpiToXs2aAccountAccessMapper;
import de.adorsys.psd2.xs2a.service.profile.AspspProfileServiceWrapper;
import de.adorsys.psd2.xs2a.service.validator.CreateConsentRequestValidator;
import de.adorsys.psd2.xs2a.service.validator.ValidationResult;
import de.adorsys.psd2.xs2a.spi.domain.SpiContextData;
import de.adorsys.psd2.xs2a.spi.domain.consent.SpiInitiateAisConsentResponse;
import de.adorsys.psd2.xs2a.spi.domain.response.SpiResponse;
import de.adorsys.psd2.xs2a.spi.service.AisConsentSpi;
import java.beans.ConstructorProperties;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

@Service
public class ConsentService {
    private final Xs2aAisConsentMapper aisConsentMapper;
    private final SpiToXs2aAccountAccessMapper spiToXs2aAccountAccessMapper;
    private final SpiResponseStatusToXs2aMessageErrorCodeMapper messageErrorCodeMapper;
    private final Xs2aAisConsentService aisConsentService;
    private final AisConsentDataService aisConsentDataService;
    private final AisAuthorizationService aisAuthorizationService;
    private final AspspProfileServiceWrapper aspspProfileService;
    private final TppService tppService;
    private final SpiContextDataProvider spiContextDataProvider;
    private final AuthorisationMethodDecider authorisationMethodDecider;
    private final AisConsentSpi aisConsentSpi;
    private final CreateConsentRequestValidator createConsentRequestValidator;
    private final Xs2aEventService xs2aEventService;
    private final AccountReferenceInConsentUpdater accountReferenceUpdater;

    public ResponseObject<CreateConsentResponse> createAccountConsentsWithResponse(CreateConsentReq request, PsuIdData psuData, boolean explicitPreferred, TppRedirectUri tppRedirectUri) {
        this.xs2aEventService.recordTppRequest(EventType.CREATE_AIS_CONSENT_REQUEST_RECEIVED, request);
        ValidationResult validationResult = this.createConsentRequestValidator.validateRequest(request);
        if (validationResult.isNotValid()) {
            return ResponseObject.builder().fail(validationResult.getMessageError()).build();
        }
        if (request.isGlobalOrAllAccountsAccessConsent()) {
            request.setAccess(this.getAccessForGlobalOrAllAvailableAccountsConsent(request));
        }
        TppInfo tppInfo = this.tppService.getTppInfo();
        tppInfo.setTppRedirectUri(tppRedirectUri);
        String consentId = this.aisConsentService.createConsent(request, psuData, tppInfo);
        if (StringUtils.isBlank((CharSequence)consentId)) {
            return ResponseObject.builder().fail(new MessageError(new TppMessageInformation(MessageCategory.ERROR, MessageErrorCode.RESOURCE_UNKNOWN_400))).build();
        }
        AccountConsent accountConsent = this.getInitialAccountConsent(consentId);
        SpiContextData contextData = this.spiContextDataProvider.provide(psuData, tppInfo);
        SpiResponse initiateAisConsentSpiResponse = this.aisConsentSpi.initiateAisConsent(contextData, this.aisConsentMapper.mapToSpiAccountConsent(accountConsent), this.aisConsentDataService.getAspspConsentDataByConsentId(consentId));
        this.aisConsentDataService.updateAspspConsentData(initiateAisConsentSpiResponse.getAspspConsentData());
        if (initiateAisConsentSpiResponse.hasError()) {
            this.aisConsentService.updateConsentStatus(consentId, ConsentStatus.REJECTED);
            return ResponseObject.builder().fail(new MessageError(new TppMessageInformation(MessageCategory.ERROR, this.messageErrorCodeMapper.mapToMessageErrorCode(initiateAisConsentSpiResponse.getResponseStatus())))).build();
        }
        Optional<Xs2aAccountAccess> xs2aAccountAccess = this.spiToXs2aAccountAccessMapper.mapToAccountAccess(((SpiInitiateAisConsentResponse)initiateAisConsentSpiResponse.getPayload()).getAccountAccess());
        xs2aAccountAccess.ifPresent(accountAccess -> this.accountReferenceUpdater.rewriteAccountAccess(consentId, (Xs2aAccountAccess)accountAccess));
        ResponseObject<CreateConsentResponse> createConsentResponseObject = ResponseObject.builder().body(new CreateConsentResponse(ConsentStatus.RECEIVED.getValue(), consentId, null, null, null, null)).build();
        if (this.isEmbeddedOrRedirectScaApproach() && this.authorisationMethodDecider.isImplicitMethod(explicitPreferred)) {
            this.proceedImplicitCaseForCreateConsent(createConsentResponseObject.getBody(), psuData, consentId);
        }
        return createConsentResponseObject;
    }

    public ResponseObject<ConsentStatusResponse> getAccountConsentsStatusById(String consentId) {
        this.xs2aEventService.recordAisTppRequest(consentId, EventType.GET_AIS_CONSENT_STATUS_REQUEST_RECEIVED);
        AccountConsent validatedAccountConsent = this.getValidatedAccountConsent(consentId);
        Optional<ConsentStatus> consentStatus = Optional.ofNullable(validatedAccountConsent).map(AccountConsent::getConsentStatus);
        ResponseObject.ResponseBuilder<Object> responseBuilder = ResponseObject.builder();
        responseBuilder = consentStatus.isPresent() ? responseBuilder.body(new ConsentStatusResponse(consentStatus.get())) : responseBuilder.fail(new MessageError(new TppMessageInformation(MessageCategory.ERROR, MessageErrorCode.CONSENT_UNKNOWN_400)));
        return responseBuilder.build();
    }

    public ResponseObject<Void> deleteAccountConsentsById(String consentId) {
        this.xs2aEventService.recordAisTppRequest(consentId, EventType.DELETE_AIS_CONSENT_REQUEST_RECEIVED);
        AccountConsent accountConsent = this.getValidatedAccountConsent(consentId);
        if (accountConsent != null) {
            SpiContextData contextData = this.spiContextDataProvider.provideWithPsuIdData(accountConsent.getPsuData());
            SpiResponse revokeAisConsentResponse = this.aisConsentSpi.revokeAisConsent(contextData, this.aisConsentMapper.mapToSpiAccountConsent(accountConsent), this.aisConsentDataService.getAspspConsentDataByConsentId(consentId));
            this.aisConsentDataService.updateAspspConsentData(revokeAisConsentResponse.getAspspConsentData());
            if (revokeAisConsentResponse.hasError()) {
                return ResponseObject.builder().fail(new MessageError(new TppMessageInformation(MessageCategory.ERROR, this.messageErrorCodeMapper.mapToMessageErrorCode(revokeAisConsentResponse.getResponseStatus())))).build();
            }
            this.aisConsentService.updateConsentStatus(consentId, ConsentStatus.TERMINATED_BY_TPP);
            return ResponseObject.builder().build();
        }
        return ResponseObject.builder().fail(new MessageError(new TppMessageInformation(MessageCategory.ERROR, MessageErrorCode.CONSENT_UNKNOWN_400))).build();
    }

    public ResponseObject<AccountConsent> getAccountConsentById(String consentId) {
        this.xs2aEventService.recordAisTppRequest(consentId, EventType.GET_AIS_CONSENT_REQUEST_RECEIVED);
        AccountConsent consent = this.getInitialAccountConsent(consentId);
        return consent == null ? ResponseObject.builder().fail(new MessageError(new TppMessageInformation(MessageCategory.ERROR, MessageErrorCode.CONSENT_UNKNOWN_403))).build() : ResponseObject.builder().body(consent).build();
    }

    public ResponseObject<AccountConsent> getValidatedConsent(String consentId, boolean withBalance) {
        AccountConsent accountConsent = this.getValidatedAccountConsent(consentId);
        if (accountConsent == null) {
            return ResponseObject.builder().fail(new MessageError(new TppMessageInformation(MessageCategory.ERROR, MessageErrorCode.CONSENT_UNKNOWN_400))).build();
        }
        if (LocalDate.now().compareTo(accountConsent.getValidUntil()) >= 0) {
            return ResponseObject.builder().fail(new MessageError(new TppMessageInformation(MessageCategory.ERROR, MessageErrorCode.CONSENT_EXPIRED))).build();
        }
        ConsentStatus consentStatus = accountConsent.getConsentStatus();
        if (consentStatus != ConsentStatus.VALID) {
            MessageErrorCode messageErrorCode = consentStatus == ConsentStatus.RECEIVED ? MessageErrorCode.CONSENT_INVALID : MessageErrorCode.CONSENT_EXPIRED;
            return ResponseObject.builder().fail(new MessageError(new TppMessageInformation(MessageCategory.ERROR, messageErrorCode))).build();
        }
        if (!accountConsent.isValidFrequency()) {
            return ResponseObject.builder().fail(new MessageError(new TppMessageInformation(MessageCategory.ERROR, MessageErrorCode.ACCESS_EXCEEDED))).build();
        }
        return ResponseObject.builder().body(accountConsent).build();
    }

    public ResponseObject<AccountConsent> getValidatedConsent(String consentId) {
        return this.getValidatedConsent(consentId, false);
    }

    public ResponseObject<CreateConsentAuthorizationResponse> createConsentAuthorizationWithResponse(PsuIdData psuData, String consentId) {
        this.xs2aEventService.recordAisTppRequest(consentId, EventType.START_AIS_CONSENT_AUTHORISATION_REQUEST_RECEIVED);
        AccountConsent accountConsent = this.getValidatedAccountConsent(consentId);
        if (accountConsent != null && accountConsent.isExpired()) {
            return ResponseObject.builder().fail(new MessageError(MessageErrorCode.CONSENT_EXPIRED)).build();
        }
        return this.aisAuthorizationService.createConsentAuthorization(psuData, consentId).map(resp -> ResponseObject.builder().body((CreateConsentAuthorizationResponse)resp).build()).orElseGet(ResponseObject.builder().fail(new MessageError(MessageErrorCode.CONSENT_UNKNOWN_400))::build);
    }

    public ResponseObject<UpdateConsentPsuDataResponse> updateConsentPsuData(UpdateConsentPsuDataReq updatePsuData) {
        this.xs2aEventService.recordAisTppRequest(updatePsuData.getConsentId(), EventType.UPDATE_AIS_CONSENT_PSU_DATA_REQUEST_RECEIVED, updatePsuData);
        AccountConsent accountConsent = this.getValidatedAccountConsent(updatePsuData.getConsentId());
        if (accountConsent != null && accountConsent.isExpired()) {
            return ResponseObject.builder().fail(new MessageError(MessageErrorCode.CONSENT_EXPIRED)).build();
        }
        return Optional.ofNullable(this.aisAuthorizationService.getAccountConsentAuthorizationById(updatePsuData.getAuthorizationId(), updatePsuData.getConsentId())).map(conAuth -> this.getUpdateConsentPsuDataResponse(updatePsuData, (AccountConsentAuthorization)conAuth)).orElseGet(ResponseObject.builder().fail(new MessageError(MessageErrorCode.RESOURCE_UNKNOWN_404))::build);
    }

    private ResponseObject<UpdateConsentPsuDataResponse> getUpdateConsentPsuDataResponse(UpdateConsentPsuDataReq updatePsuData, AccountConsentAuthorization consentAuthorization) {
        UpdateConsentPsuDataResponse response = this.aisAuthorizationService.updateConsentPsuData(updatePsuData, consentAuthorization);
        return Optional.ofNullable(response).map(s -> Optional.ofNullable(s.getErrorCode()).map(e -> ResponseObject.builder().fail(new MessageError((MessageErrorCode)((Object)((Object)e)))).build()).orElseGet(ResponseObject.builder().body(response)::build)).orElseGet(ResponseObject.builder().fail(new MessageError(MessageErrorCode.FORMAT_ERROR))::build);
    }

    public ResponseObject<Xs2aAuthorisationSubResources> getConsentInitiationAuthorisations(String consentId) {
        this.xs2aEventService.recordAisTppRequest(consentId, EventType.GET_CONSENT_AUTHORISATION_REQUEST_RECEIVED);
        return this.aisAuthorizationService.getAuthorisationSubResources(consentId).map(resp -> ResponseObject.builder().body((Xs2aAuthorisationSubResources)resp).build()).orElseGet(ResponseObject.builder().fail(new MessageError(MessageErrorCode.RESOURCE_UNKNOWN_404))::build);
    }

    public ResponseObject<ScaStatus> getConsentAuthorisationScaStatus(String consentId, String authorisationId) {
        this.xs2aEventService.recordAisTppRequest(consentId, EventType.GET_CONSENT_SCA_STATUS_REQUEST_RECEIVED);
        Optional<ScaStatus> scaStatus = this.aisAuthorizationService.getAuthorisationScaStatus(consentId, authorisationId);
        if (!scaStatus.isPresent()) {
            return ResponseObject.builder().fail(new MessageError(MessageErrorCode.RESOURCE_UNKNOWN_403)).build();
        }
        return ResponseObject.builder().body(scaStatus.get()).build();
    }

    public boolean isValidAccountByAccess(String resourceId, List<AccountReference> allowedAccountData) {
        return CollectionUtils.isNotEmpty(allowedAccountData) && allowedAccountData.stream().anyMatch(a -> a.getResourceId().equals(resourceId));
    }

    private Xs2aAccountAccess getAccessForGlobalOrAllAvailableAccountsConsent(CreateConsentReq request) {
        return new Xs2aAccountAccess(new ArrayList<AccountReference>(), new ArrayList<AccountReference>(), new ArrayList<AccountReference>(), request.getAccess().getAvailableAccounts(), request.getAccess().getAllPsd2());
    }

    private AccountConsent getValidatedAccountConsent(String consentId) {
        return Optional.ofNullable(this.aisConsentService.getAccountConsentById(consentId)).filter(consent -> this.tppService.getTppId().equals(consent.getTppInfo().getAuthorisationNumber())).orElse(null);
    }

    private AccountConsent getInitialAccountConsent(String consentId) {
        return Optional.ofNullable(this.aisConsentService.getInitialAccountConsentById(consentId)).filter(consent -> this.tppService.getTppId().equals(consent.getTppInfo().getAuthorisationNumber())).orElse(null);
    }

    private void proceedImplicitCaseForCreateConsent(CreateConsentResponse response, PsuIdData psuData, String consentId) {
        this.aisAuthorizationService.createConsentAuthorization(psuData, consentId).ifPresent(a -> response.setAuthorizationId(a.getAuthorizationId()));
    }

    private boolean isEmbeddedOrRedirectScaApproach() {
        return EnumSet.of(ScaApproach.EMBEDDED, ScaApproach.REDIRECT).contains(this.aspspProfileService.getScaApproach());
    }

    @ConstructorProperties(value={"aisConsentMapper", "spiToXs2aAccountAccessMapper", "messageErrorCodeMapper", "aisConsentService", "aisConsentDataService", "aisAuthorizationService", "aspspProfileService", "tppService", "spiContextDataProvider", "authorisationMethodDecider", "aisConsentSpi", "createConsentRequestValidator", "xs2aEventService", "accountReferenceUpdater"})
    public ConsentService(Xs2aAisConsentMapper aisConsentMapper, SpiToXs2aAccountAccessMapper spiToXs2aAccountAccessMapper, SpiResponseStatusToXs2aMessageErrorCodeMapper messageErrorCodeMapper, Xs2aAisConsentService aisConsentService, AisConsentDataService aisConsentDataService, AisAuthorizationService aisAuthorizationService, AspspProfileServiceWrapper aspspProfileService, TppService tppService, SpiContextDataProvider spiContextDataProvider, AuthorisationMethodDecider authorisationMethodDecider, AisConsentSpi aisConsentSpi, CreateConsentRequestValidator createConsentRequestValidator, Xs2aEventService xs2aEventService, AccountReferenceInConsentUpdater accountReferenceUpdater) {
        this.aisConsentMapper = aisConsentMapper;
        this.spiToXs2aAccountAccessMapper = spiToXs2aAccountAccessMapper;
        this.messageErrorCodeMapper = messageErrorCodeMapper;
        this.aisConsentService = aisConsentService;
        this.aisConsentDataService = aisConsentDataService;
        this.aisAuthorizationService = aisAuthorizationService;
        this.aspspProfileService = aspspProfileService;
        this.tppService = tppService;
        this.spiContextDataProvider = spiContextDataProvider;
        this.authorisationMethodDecider = authorisationMethodDecider;
        this.aisConsentSpi = aisConsentSpi;
        this.createConsentRequestValidator = createConsentRequestValidator;
        this.xs2aEventService = xs2aEventService;
        this.accountReferenceUpdater = accountReferenceUpdater;
    }
}

