/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.exception;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonUnwrapped;
import de.adorsys.psd2.xs2a.core.pis.TransactionStatus;
import de.adorsys.psd2.xs2a.domain.ErrorHolder;
import de.adorsys.psd2.xs2a.domain.MessageErrorCode;
import de.adorsys.psd2.xs2a.domain.TppMessageInformation;
import de.adorsys.psd2.xs2a.exception.MessageCategory;
import io.swagger.annotations.ApiModelProperty;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class MessageError {
    @JsonUnwrapped
    @ApiModelProperty(value="Transaction status", example="Rejected")
    private TransactionStatus transactionStatus;
    @ApiModelProperty(value="Tpp messages information of the Berlin Group XS2A Interface")
    private Set<TppMessageInformation> tppMessages = new HashSet<TppMessageInformation>();

    public MessageError(TppMessageInformation tppMessage) {
        this(TransactionStatus.RJCT, tppMessage);
    }

    public MessageError(List<TppMessageInformation> tppMessages) {
        this(TransactionStatus.RJCT, tppMessages);
    }

    public MessageError(TransactionStatus status, TppMessageInformation tppMessage) {
        this(status, Collections.singletonList(tppMessage));
    }

    public MessageError(ErrorHolder errorHolder) {
        this(errorHolder.getErrorCode(), errorHolder.getMessage());
    }

    public MessageError(TransactionStatus status, List<TppMessageInformation> tppMessages) {
        this.transactionStatus = status;
        this.tppMessages.addAll(tppMessages);
    }

    public MessageError(MessageErrorCode errorCode, String message) {
        this(TransactionStatus.RJCT, Collections.singletonList(new TppMessageInformation(MessageCategory.ERROR, errorCode, message)));
    }

    public MessageError(MessageErrorCode errorCode) {
        this(errorCode, null);
    }

    @JsonIgnore
    public TppMessageInformation getTppMessage() {
        return this.tppMessages.iterator().next();
    }

    public TransactionStatus getTransactionStatus() {
        return this.transactionStatus;
    }

    public Set<TppMessageInformation> getTppMessages() {
        return this.tppMessages;
    }

    public void setTransactionStatus(TransactionStatus transactionStatus) {
        this.transactionStatus = transactionStatus;
    }

    public void setTppMessages(Set<TppMessageInformation> tppMessages) {
        this.tppMessages = tppMessages;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MessageError)) {
            return false;
        }
        MessageError other = (MessageError)o;
        if (!other.canEqual(this)) {
            return false;
        }
        TransactionStatus this$transactionStatus = this.getTransactionStatus();
        TransactionStatus other$transactionStatus = other.getTransactionStatus();
        if (this$transactionStatus == null ? other$transactionStatus != null : !this$transactionStatus.equals(other$transactionStatus)) {
            return false;
        }
        Set<TppMessageInformation> this$tppMessages = this.getTppMessages();
        Set<TppMessageInformation> other$tppMessages = other.getTppMessages();
        return !(this$tppMessages == null ? other$tppMessages != null : !((Object)this$tppMessages).equals(other$tppMessages));
    }

    protected boolean canEqual(Object other) {
        return other instanceof MessageError;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        TransactionStatus $transactionStatus = this.getTransactionStatus();
        result = result * 59 + ($transactionStatus == null ? 43 : $transactionStatus.hashCode());
        Set<TppMessageInformation> $tppMessages = this.getTppMessages();
        result = result * 59 + ($tppMessages == null ? 43 : ((Object)$tppMessages).hashCode());
        return result;
    }

    public String toString() {
        return "MessageError(transactionStatus=" + this.getTransactionStatus() + ", tppMessages=" + this.getTppMessages() + ")";
    }
}

