/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.domain.pis;

import com.fasterxml.jackson.annotation.JsonIgnore;
import de.adorsys.psd2.xs2a.core.pis.TransactionStatus;
import de.adorsys.psd2.xs2a.core.profile.AccountReference;
import de.adorsys.psd2.xs2a.domain.AccountReferenceCollector;
import de.adorsys.psd2.xs2a.domain.Xs2aAmount;
import de.adorsys.psd2.xs2a.domain.address.Xs2aAddress;
import de.adorsys.psd2.xs2a.domain.code.Xs2aPurposeCode;
import de.adorsys.psd2.xs2a.domain.pis.Remittance;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.LocalDate;
import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;

@ApiModel(description="Payment Initialisation Request", value="SinglePayments")
public class SinglePayment
implements AccountReferenceCollector {
    private String paymentId;
    @Size(max=35)
    @ApiModelProperty(value="end to end identification", example="RI-123456789")
    private @Size(max=35) String endToEndIdentification;
    @NotNull
    @ApiModelProperty(value="debtor account", required=true)
    private AccountReference debtorAccount;
    @Deprecated
    @Size(max=70)
    @ApiModelProperty(value="ultimate debtor", example="Mueller")
    private @Size(max=70) String ultimateDebtor;
    @Valid
    @NotNull
    @ApiModelProperty(value="instructed amount", required=true)
    private Xs2aAmount instructedAmount;
    @NotNull
    @ApiModelProperty(value="creditor account", required=true)
    private AccountReference creditorAccount;
    @ApiModelProperty(value="creditor agent")
    private String creditorAgent;
    @NotNull
    @Size(max=70)
    @ApiModelProperty(value="creditor name", required=true, example="Telekom")
    private @NotNull @Size(max=70) String creditorName;
    @Valid
    @ApiModelProperty(value="creditor Address")
    private Xs2aAddress creditorAddress;
    @Deprecated
    @Size(max=70)
    @ApiModelProperty(value="ultimate creditor", example="Telekom")
    private @Size(max=70) String ultimateCreditor;
    @Deprecated
    @ApiModelProperty(value="purpose code")
    private Xs2aPurposeCode purposeCode;
    @Size(max=140)
    @ApiModelProperty(value="remittance information unstructured", example="Ref. Number TELEKOM-1222")
    private @Size(max=140) String remittanceInformationUnstructured;
    @Deprecated
    @Valid
    @ApiModelProperty(value="remittance information structured")
    private Remittance remittanceInformationStructured;
    @ApiModelProperty(value="requested execution date", example="2020-01-01")
    private LocalDate requestedExecutionDate;
    @ApiModelProperty(value="requested execution time", example="2020-01-01T15:30:35.035Z")
    private OffsetDateTime requestedExecutionTime;
    @ApiModelProperty(value="Transaction status", example="Pending")
    private TransactionStatus transactionStatus;

    @Override
    @JsonIgnore
    public Set<AccountReference> getAccountReferences() {
        return new HashSet<AccountReference>(Arrays.asList(this.debtorAccount, this.creditorAccount));
    }

    public String getPaymentId() {
        return this.paymentId;
    }

    public String getEndToEndIdentification() {
        return this.endToEndIdentification;
    }

    public AccountReference getDebtorAccount() {
        return this.debtorAccount;
    }

    @Deprecated
    public String getUltimateDebtor() {
        return this.ultimateDebtor;
    }

    public Xs2aAmount getInstructedAmount() {
        return this.instructedAmount;
    }

    public AccountReference getCreditorAccount() {
        return this.creditorAccount;
    }

    public String getCreditorAgent() {
        return this.creditorAgent;
    }

    public String getCreditorName() {
        return this.creditorName;
    }

    public Xs2aAddress getCreditorAddress() {
        return this.creditorAddress;
    }

    @Deprecated
    public String getUltimateCreditor() {
        return this.ultimateCreditor;
    }

    @Deprecated
    public Xs2aPurposeCode getPurposeCode() {
        return this.purposeCode;
    }

    public String getRemittanceInformationUnstructured() {
        return this.remittanceInformationUnstructured;
    }

    @Deprecated
    public Remittance getRemittanceInformationStructured() {
        return this.remittanceInformationStructured;
    }

    public LocalDate getRequestedExecutionDate() {
        return this.requestedExecutionDate;
    }

    public OffsetDateTime getRequestedExecutionTime() {
        return this.requestedExecutionTime;
    }

    public TransactionStatus getTransactionStatus() {
        return this.transactionStatus;
    }

    public void setPaymentId(String paymentId) {
        this.paymentId = paymentId;
    }

    public void setEndToEndIdentification(String endToEndIdentification) {
        this.endToEndIdentification = endToEndIdentification;
    }

    public void setDebtorAccount(AccountReference debtorAccount) {
        this.debtorAccount = debtorAccount;
    }

    @Deprecated
    public void setUltimateDebtor(String ultimateDebtor) {
        this.ultimateDebtor = ultimateDebtor;
    }

    public void setInstructedAmount(Xs2aAmount instructedAmount) {
        this.instructedAmount = instructedAmount;
    }

    public void setCreditorAccount(AccountReference creditorAccount) {
        this.creditorAccount = creditorAccount;
    }

    public void setCreditorAgent(String creditorAgent) {
        this.creditorAgent = creditorAgent;
    }

    public void setCreditorName(String creditorName) {
        this.creditorName = creditorName;
    }

    public void setCreditorAddress(Xs2aAddress creditorAddress) {
        this.creditorAddress = creditorAddress;
    }

    @Deprecated
    public void setUltimateCreditor(String ultimateCreditor) {
        this.ultimateCreditor = ultimateCreditor;
    }

    @Deprecated
    public void setPurposeCode(Xs2aPurposeCode purposeCode) {
        this.purposeCode = purposeCode;
    }

    public void setRemittanceInformationUnstructured(String remittanceInformationUnstructured) {
        this.remittanceInformationUnstructured = remittanceInformationUnstructured;
    }

    @Deprecated
    public void setRemittanceInformationStructured(Remittance remittanceInformationStructured) {
        this.remittanceInformationStructured = remittanceInformationStructured;
    }

    public void setRequestedExecutionDate(LocalDate requestedExecutionDate) {
        this.requestedExecutionDate = requestedExecutionDate;
    }

    public void setRequestedExecutionTime(OffsetDateTime requestedExecutionTime) {
        this.requestedExecutionTime = requestedExecutionTime;
    }

    public void setTransactionStatus(TransactionStatus transactionStatus) {
        this.transactionStatus = transactionStatus;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SinglePayment)) {
            return false;
        }
        SinglePayment other = (SinglePayment)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$paymentId = this.getPaymentId();
        String other$paymentId = other.getPaymentId();
        if (this$paymentId == null ? other$paymentId != null : !this$paymentId.equals(other$paymentId)) {
            return false;
        }
        String this$endToEndIdentification = this.getEndToEndIdentification();
        String other$endToEndIdentification = other.getEndToEndIdentification();
        if (this$endToEndIdentification == null ? other$endToEndIdentification != null : !this$endToEndIdentification.equals(other$endToEndIdentification)) {
            return false;
        }
        AccountReference this$debtorAccount = this.getDebtorAccount();
        AccountReference other$debtorAccount = other.getDebtorAccount();
        if (this$debtorAccount == null ? other$debtorAccount != null : !this$debtorAccount.equals(other$debtorAccount)) {
            return false;
        }
        String this$ultimateDebtor = this.getUltimateDebtor();
        String other$ultimateDebtor = other.getUltimateDebtor();
        if (this$ultimateDebtor == null ? other$ultimateDebtor != null : !this$ultimateDebtor.equals(other$ultimateDebtor)) {
            return false;
        }
        Xs2aAmount this$instructedAmount = this.getInstructedAmount();
        Xs2aAmount other$instructedAmount = other.getInstructedAmount();
        if (this$instructedAmount == null ? other$instructedAmount != null : !((Object)this$instructedAmount).equals(other$instructedAmount)) {
            return false;
        }
        AccountReference this$creditorAccount = this.getCreditorAccount();
        AccountReference other$creditorAccount = other.getCreditorAccount();
        if (this$creditorAccount == null ? other$creditorAccount != null : !this$creditorAccount.equals(other$creditorAccount)) {
            return false;
        }
        String this$creditorAgent = this.getCreditorAgent();
        String other$creditorAgent = other.getCreditorAgent();
        if (this$creditorAgent == null ? other$creditorAgent != null : !this$creditorAgent.equals(other$creditorAgent)) {
            return false;
        }
        String this$creditorName = this.getCreditorName();
        String other$creditorName = other.getCreditorName();
        if (this$creditorName == null ? other$creditorName != null : !this$creditorName.equals(other$creditorName)) {
            return false;
        }
        Xs2aAddress this$creditorAddress = this.getCreditorAddress();
        Xs2aAddress other$creditorAddress = other.getCreditorAddress();
        if (this$creditorAddress == null ? other$creditorAddress != null : !((Object)this$creditorAddress).equals(other$creditorAddress)) {
            return false;
        }
        String this$ultimateCreditor = this.getUltimateCreditor();
        String other$ultimateCreditor = other.getUltimateCreditor();
        if (this$ultimateCreditor == null ? other$ultimateCreditor != null : !this$ultimateCreditor.equals(other$ultimateCreditor)) {
            return false;
        }
        Xs2aPurposeCode this$purposeCode = this.getPurposeCode();
        Xs2aPurposeCode other$purposeCode = other.getPurposeCode();
        if (this$purposeCode == null ? other$purposeCode != null : !((Object)this$purposeCode).equals(other$purposeCode)) {
            return false;
        }
        String this$remittanceInformationUnstructured = this.getRemittanceInformationUnstructured();
        String other$remittanceInformationUnstructured = other.getRemittanceInformationUnstructured();
        if (this$remittanceInformationUnstructured == null ? other$remittanceInformationUnstructured != null : !this$remittanceInformationUnstructured.equals(other$remittanceInformationUnstructured)) {
            return false;
        }
        Remittance this$remittanceInformationStructured = this.getRemittanceInformationStructured();
        Remittance other$remittanceInformationStructured = other.getRemittanceInformationStructured();
        if (this$remittanceInformationStructured == null ? other$remittanceInformationStructured != null : !((Object)this$remittanceInformationStructured).equals(other$remittanceInformationStructured)) {
            return false;
        }
        LocalDate this$requestedExecutionDate = this.getRequestedExecutionDate();
        LocalDate other$requestedExecutionDate = other.getRequestedExecutionDate();
        if (this$requestedExecutionDate == null ? other$requestedExecutionDate != null : !((Object)this$requestedExecutionDate).equals(other$requestedExecutionDate)) {
            return false;
        }
        OffsetDateTime this$requestedExecutionTime = this.getRequestedExecutionTime();
        OffsetDateTime other$requestedExecutionTime = other.getRequestedExecutionTime();
        if (this$requestedExecutionTime == null ? other$requestedExecutionTime != null : !((Object)this$requestedExecutionTime).equals(other$requestedExecutionTime)) {
            return false;
        }
        TransactionStatus this$transactionStatus = this.getTransactionStatus();
        TransactionStatus other$transactionStatus = other.getTransactionStatus();
        return !(this$transactionStatus == null ? other$transactionStatus != null : !this$transactionStatus.equals(other$transactionStatus));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SinglePayment;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $paymentId = this.getPaymentId();
        result = result * 59 + ($paymentId == null ? 43 : $paymentId.hashCode());
        String $endToEndIdentification = this.getEndToEndIdentification();
        result = result * 59 + ($endToEndIdentification == null ? 43 : $endToEndIdentification.hashCode());
        AccountReference $debtorAccount = this.getDebtorAccount();
        result = result * 59 + ($debtorAccount == null ? 43 : $debtorAccount.hashCode());
        String $ultimateDebtor = this.getUltimateDebtor();
        result = result * 59 + ($ultimateDebtor == null ? 43 : $ultimateDebtor.hashCode());
        Xs2aAmount $instructedAmount = this.getInstructedAmount();
        result = result * 59 + ($instructedAmount == null ? 43 : ((Object)$instructedAmount).hashCode());
        AccountReference $creditorAccount = this.getCreditorAccount();
        result = result * 59 + ($creditorAccount == null ? 43 : $creditorAccount.hashCode());
        String $creditorAgent = this.getCreditorAgent();
        result = result * 59 + ($creditorAgent == null ? 43 : $creditorAgent.hashCode());
        String $creditorName = this.getCreditorName();
        result = result * 59 + ($creditorName == null ? 43 : $creditorName.hashCode());
        Xs2aAddress $creditorAddress = this.getCreditorAddress();
        result = result * 59 + ($creditorAddress == null ? 43 : ((Object)$creditorAddress).hashCode());
        String $ultimateCreditor = this.getUltimateCreditor();
        result = result * 59 + ($ultimateCreditor == null ? 43 : $ultimateCreditor.hashCode());
        Xs2aPurposeCode $purposeCode = this.getPurposeCode();
        result = result * 59 + ($purposeCode == null ? 43 : ((Object)$purposeCode).hashCode());
        String $remittanceInformationUnstructured = this.getRemittanceInformationUnstructured();
        result = result * 59 + ($remittanceInformationUnstructured == null ? 43 : $remittanceInformationUnstructured.hashCode());
        Remittance $remittanceInformationStructured = this.getRemittanceInformationStructured();
        result = result * 59 + ($remittanceInformationStructured == null ? 43 : ((Object)$remittanceInformationStructured).hashCode());
        LocalDate $requestedExecutionDate = this.getRequestedExecutionDate();
        result = result * 59 + ($requestedExecutionDate == null ? 43 : ((Object)$requestedExecutionDate).hashCode());
        OffsetDateTime $requestedExecutionTime = this.getRequestedExecutionTime();
        result = result * 59 + ($requestedExecutionTime == null ? 43 : ((Object)$requestedExecutionTime).hashCode());
        TransactionStatus $transactionStatus = this.getTransactionStatus();
        result = result * 59 + ($transactionStatus == null ? 43 : $transactionStatus.hashCode());
        return result;
    }

    public String toString() {
        return "SinglePayment(paymentId=" + this.getPaymentId() + ", endToEndIdentification=" + this.getEndToEndIdentification() + ", debtorAccount=" + this.getDebtorAccount() + ", ultimateDebtor=" + this.getUltimateDebtor() + ", instructedAmount=" + this.getInstructedAmount() + ", creditorAccount=" + this.getCreditorAccount() + ", creditorAgent=" + this.getCreditorAgent() + ", creditorName=" + this.getCreditorName() + ", creditorAddress=" + this.getCreditorAddress() + ", ultimateCreditor=" + this.getUltimateCreditor() + ", purposeCode=" + this.getPurposeCode() + ", remittanceInformationUnstructured=" + this.getRemittanceInformationUnstructured() + ", remittanceInformationStructured=" + this.getRemittanceInformationStructured() + ", requestedExecutionDate=" + this.getRequestedExecutionDate() + ", requestedExecutionTime=" + this.getRequestedExecutionTime() + ", transactionStatus=" + this.getTransactionStatus() + ")";
    }
}

