/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.domain.consent;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

@ApiModel(description="AccountAccess type", value="AisAccountAccessType")
public enum Xs2aAccountAccessType {
    ALL_ACCOUNTS("allAccounts"),
    ALL_ACCOUNTS_WITH_BALANCES("allAccountsWithBalances");

    private static Map<String, Xs2aAccountAccessType> container;
    @ApiModelProperty(value="description", example="allAccounts")
    private String description;

    @JsonCreator
    private Xs2aAccountAccessType(String description) {
        this.description = description;
    }

    @JsonValue
    public String getDescription() {
        return this.description;
    }

    public static Optional<Xs2aAccountAccessType> getByDescription(String description) {
        return Optional.ofNullable(container.get(description));
    }

    static {
        container = new HashMap<String, Xs2aAccountAccessType>();
        Arrays.stream(Xs2aAccountAccessType.values()).forEach(aat -> container.put(aat.getDescription(), (Xs2aAccountAccessType)((Object)aat)));
    }
}

