/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.domain.consent;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import de.adorsys.psd2.xs2a.core.sca.ChallengeData;
import de.adorsys.psd2.xs2a.domain.Links;
import de.adorsys.psd2.xs2a.domain.consent.Xs2aAuthenticationObject;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.beans.ConstructorProperties;
import java.util.Arrays;

@ApiModel(description="Response for the create account information consent request in the Account service")
public class CreateConsentResponse {
    @ApiModelProperty(value="Authentication status of the consent", required=true)
    private final String consentStatus;
    @ApiModelProperty(value="Identification of the consent resource as it is used in the API structure", required=false)
    private final String consentId;
    @ApiModelProperty(value="This data element might be contained, if SCA is required and if the PSU has a choice between different authentication methods. Depending on the risk management of the ASPSP this choice might be offered before or after the PSU has been identified with the first relevant factor, or if an access token is transported. If this data element is contained, then there is also an hyperlink of type 'selectAuthenticationMethods' contained in the response body.", required=false)
    private final Xs2aAuthenticationObject[] scaMethods;
    @ApiModelProperty(value="This data element is only contained in the response if the APSPS has chosen the Embedded SCA Approach, if the PSU is already identified with the first relevant factor or alternatively an access token, if SCA is required and if the authentication method is implicitly selected")
    private final Xs2aAuthenticationObject chosenScaMethod;
    @ApiModelProperty(value="It is contained in addition to the data element chosenScaMethod if challenge data is needed for SCA")
    private final ChallengeData challengeData;
    @ApiModelProperty(value="A list of hyperlinks to be recognized by Tpp", required=true)
    @JsonProperty(value="_links")
    private Links links = new Links();
    @ApiModelProperty(value="Text to be displayed to the PSU, e.g. in a Decoupled SCA Approach", required=false)
    private final String psuMessage;
    @JsonIgnore
    private String authorizationId;

    @ConstructorProperties(value={"consentStatus", "consentId", "scaMethods", "chosenScaMethod", "challengeData", "psuMessage"})
    public CreateConsentResponse(String consentStatus, String consentId, Xs2aAuthenticationObject[] scaMethods, Xs2aAuthenticationObject chosenScaMethod, ChallengeData challengeData, String psuMessage) {
        this.consentStatus = consentStatus;
        this.consentId = consentId;
        this.scaMethods = scaMethods;
        this.chosenScaMethod = chosenScaMethod;
        this.challengeData = challengeData;
        this.psuMessage = psuMessage;
    }

    public String getConsentStatus() {
        return this.consentStatus;
    }

    public String getConsentId() {
        return this.consentId;
    }

    public Xs2aAuthenticationObject[] getScaMethods() {
        return this.scaMethods;
    }

    public Xs2aAuthenticationObject getChosenScaMethod() {
        return this.chosenScaMethod;
    }

    public ChallengeData getChallengeData() {
        return this.challengeData;
    }

    public Links getLinks() {
        return this.links;
    }

    public String getPsuMessage() {
        return this.psuMessage;
    }

    public String getAuthorizationId() {
        return this.authorizationId;
    }

    public void setLinks(Links links) {
        this.links = links;
    }

    public void setAuthorizationId(String authorizationId) {
        this.authorizationId = authorizationId;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CreateConsentResponse)) {
            return false;
        }
        CreateConsentResponse other = (CreateConsentResponse)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$consentStatus = this.getConsentStatus();
        String other$consentStatus = other.getConsentStatus();
        if (this$consentStatus == null ? other$consentStatus != null : !this$consentStatus.equals(other$consentStatus)) {
            return false;
        }
        String this$consentId = this.getConsentId();
        String other$consentId = other.getConsentId();
        if (this$consentId == null ? other$consentId != null : !this$consentId.equals(other$consentId)) {
            return false;
        }
        if (!Arrays.deepEquals(this.getScaMethods(), other.getScaMethods())) {
            return false;
        }
        Xs2aAuthenticationObject this$chosenScaMethod = this.getChosenScaMethod();
        Xs2aAuthenticationObject other$chosenScaMethod = other.getChosenScaMethod();
        if (this$chosenScaMethod == null ? other$chosenScaMethod != null : !((Object)this$chosenScaMethod).equals(other$chosenScaMethod)) {
            return false;
        }
        ChallengeData this$challengeData = this.getChallengeData();
        ChallengeData other$challengeData = other.getChallengeData();
        if (this$challengeData == null ? other$challengeData != null : !this$challengeData.equals(other$challengeData)) {
            return false;
        }
        Links this$links = this.getLinks();
        Links other$links = other.getLinks();
        if (this$links == null ? other$links != null : !((Object)this$links).equals(other$links)) {
            return false;
        }
        String this$psuMessage = this.getPsuMessage();
        String other$psuMessage = other.getPsuMessage();
        if (this$psuMessage == null ? other$psuMessage != null : !this$psuMessage.equals(other$psuMessage)) {
            return false;
        }
        String this$authorizationId = this.getAuthorizationId();
        String other$authorizationId = other.getAuthorizationId();
        return !(this$authorizationId == null ? other$authorizationId != null : !this$authorizationId.equals(other$authorizationId));
    }

    protected boolean canEqual(Object other) {
        return other instanceof CreateConsentResponse;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $consentStatus = this.getConsentStatus();
        result = result * 59 + ($consentStatus == null ? 43 : $consentStatus.hashCode());
        String $consentId = this.getConsentId();
        result = result * 59 + ($consentId == null ? 43 : $consentId.hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getScaMethods());
        Xs2aAuthenticationObject $chosenScaMethod = this.getChosenScaMethod();
        result = result * 59 + ($chosenScaMethod == null ? 43 : ((Object)$chosenScaMethod).hashCode());
        ChallengeData $challengeData = this.getChallengeData();
        result = result * 59 + ($challengeData == null ? 43 : $challengeData.hashCode());
        Links $links = this.getLinks();
        result = result * 59 + ($links == null ? 43 : ((Object)$links).hashCode());
        String $psuMessage = this.getPsuMessage();
        result = result * 59 + ($psuMessage == null ? 43 : $psuMessage.hashCode());
        String $authorizationId = this.getAuthorizationId();
        result = result * 59 + ($authorizationId == null ? 43 : $authorizationId.hashCode());
        return result;
    }

    public String toString() {
        return "CreateConsentResponse(consentStatus=" + this.getConsentStatus() + ", consentId=" + this.getConsentId() + ", scaMethods=" + Arrays.deepToString(this.getScaMethods()) + ", chosenScaMethod=" + this.getChosenScaMethod() + ", challengeData=" + this.getChallengeData() + ", links=" + this.getLinks() + ", psuMessage=" + this.getPsuMessage() + ", authorizationId=" + this.getAuthorizationId() + ")";
    }
}

