/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.domain.consent;

import com.fasterxml.jackson.annotation.JsonIgnore;
import de.adorsys.psd2.xs2a.core.consent.AisConsentRequestType;
import de.adorsys.psd2.xs2a.core.consent.ConsentStatus;
import de.adorsys.psd2.xs2a.core.psu.PsuIdData;
import de.adorsys.psd2.xs2a.core.tpp.TppInfo;
import de.adorsys.psd2.xs2a.domain.consent.Xs2aAccountAccess;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.beans.ConstructorProperties;
import java.time.LocalDate;

@ApiModel(description="Response for the get account information consent request by consent Id")
public class AccountConsent {
    @ApiModelProperty(value="ID of the corresponding consent object as returned by an Account Information Consent Request", required=true)
    @JsonIgnore
    private final String id;
    @ApiModelProperty(value="Access", required=true)
    private final Xs2aAccountAccess access;
    @ApiModelProperty(value="'true', if the consent is for recurring access to the account data , 'false', if the consent is for one access to the account data", required=true)
    private final boolean recurringIndicator;
    @ApiModelProperty(value="valid until date for the requested consent. The content is the local ASPSP date in ISODate Format", required=true, example="2017-10-30")
    private final LocalDate validUntil;
    @ApiModelProperty(value="requested maximum frequency for an access per day. For a once-off access, this attribute is set to 1", required=true, example="4")
    private final int frequencyPerDay;
    @ApiModelProperty(value="This date is containing the date of the last action on the consent object either through the XS2A interface or the PSU/ASPSP interface having an impact on the status.", required=true, example="2017-10-30")
    private final LocalDate lastActionDate;
    @ApiModelProperty(value="The following code values are permitted 'received', 'valid', 'rejected', 'expired', 'revoked by psu', 'terminated by tpp'. These values might be extended by ASPSP by more values.", required=true, example="VALID")
    private final ConsentStatus consentStatus;
    @ApiModelProperty(name="withBalance", value="If contained, this function reads the list of accessible payment accounts including the balance.")
    @JsonIgnore
    private final boolean withBalance;
    @ApiModelProperty(name="tppRedirectPreferred", value="If it equals \u201ctrue\u201d, the TPP prefers a redirect over an embedded SCA approach.")
    @JsonIgnore
    private final boolean tppRedirectPreferred;
    @ApiModelProperty(value="Corresponding PSU", name="psuData")
    @JsonIgnore
    private final PsuIdData psuData;
    @ApiModelProperty(value="TPP information", required=true)
    @JsonIgnore
    private final TppInfo tppInfo;
    @JsonIgnore
    private final AisConsentRequestType aisConsentRequestType;

    @JsonIgnore
    public boolean isValidFrequency() {
        return this.frequencyPerDay > 0;
    }

    @JsonIgnore
    public boolean isExpired() {
        return this.consentStatus == ConsentStatus.EXPIRED;
    }

    @ConstructorProperties(value={"id", "access", "recurringIndicator", "validUntil", "frequencyPerDay", "lastActionDate", "consentStatus", "withBalance", "tppRedirectPreferred", "psuData", "tppInfo", "aisConsentRequestType"})
    public AccountConsent(String id, Xs2aAccountAccess access, boolean recurringIndicator, LocalDate validUntil, int frequencyPerDay, LocalDate lastActionDate, ConsentStatus consentStatus, boolean withBalance, boolean tppRedirectPreferred, PsuIdData psuData, TppInfo tppInfo, AisConsentRequestType aisConsentRequestType) {
        this.id = id;
        this.access = access;
        this.recurringIndicator = recurringIndicator;
        this.validUntil = validUntil;
        this.frequencyPerDay = frequencyPerDay;
        this.lastActionDate = lastActionDate;
        this.consentStatus = consentStatus;
        this.withBalance = withBalance;
        this.tppRedirectPreferred = tppRedirectPreferred;
        this.psuData = psuData;
        this.tppInfo = tppInfo;
        this.aisConsentRequestType = aisConsentRequestType;
    }

    public String getId() {
        return this.id;
    }

    public Xs2aAccountAccess getAccess() {
        return this.access;
    }

    public boolean isRecurringIndicator() {
        return this.recurringIndicator;
    }

    public LocalDate getValidUntil() {
        return this.validUntil;
    }

    public int getFrequencyPerDay() {
        return this.frequencyPerDay;
    }

    public LocalDate getLastActionDate() {
        return this.lastActionDate;
    }

    public ConsentStatus getConsentStatus() {
        return this.consentStatus;
    }

    public boolean isWithBalance() {
        return this.withBalance;
    }

    public boolean isTppRedirectPreferred() {
        return this.tppRedirectPreferred;
    }

    public PsuIdData getPsuData() {
        return this.psuData;
    }

    public TppInfo getTppInfo() {
        return this.tppInfo;
    }

    public AisConsentRequestType getAisConsentRequestType() {
        return this.aisConsentRequestType;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AccountConsent)) {
            return false;
        }
        AccountConsent other = (AccountConsent)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        Xs2aAccountAccess this$access = this.getAccess();
        Xs2aAccountAccess other$access = other.getAccess();
        if (this$access == null ? other$access != null : !((Object)this$access).equals(other$access)) {
            return false;
        }
        if (this.isRecurringIndicator() != other.isRecurringIndicator()) {
            return false;
        }
        LocalDate this$validUntil = this.getValidUntil();
        LocalDate other$validUntil = other.getValidUntil();
        if (this$validUntil == null ? other$validUntil != null : !((Object)this$validUntil).equals(other$validUntil)) {
            return false;
        }
        if (this.getFrequencyPerDay() != other.getFrequencyPerDay()) {
            return false;
        }
        LocalDate this$lastActionDate = this.getLastActionDate();
        LocalDate other$lastActionDate = other.getLastActionDate();
        if (this$lastActionDate == null ? other$lastActionDate != null : !((Object)this$lastActionDate).equals(other$lastActionDate)) {
            return false;
        }
        ConsentStatus this$consentStatus = this.getConsentStatus();
        ConsentStatus other$consentStatus = other.getConsentStatus();
        if (this$consentStatus == null ? other$consentStatus != null : !this$consentStatus.equals(other$consentStatus)) {
            return false;
        }
        if (this.isWithBalance() != other.isWithBalance()) {
            return false;
        }
        if (this.isTppRedirectPreferred() != other.isTppRedirectPreferred()) {
            return false;
        }
        PsuIdData this$psuData = this.getPsuData();
        PsuIdData other$psuData = other.getPsuData();
        if (this$psuData == null ? other$psuData != null : !this$psuData.equals(other$psuData)) {
            return false;
        }
        TppInfo this$tppInfo = this.getTppInfo();
        TppInfo other$tppInfo = other.getTppInfo();
        if (this$tppInfo == null ? other$tppInfo != null : !this$tppInfo.equals(other$tppInfo)) {
            return false;
        }
        AisConsentRequestType this$aisConsentRequestType = this.getAisConsentRequestType();
        AisConsentRequestType other$aisConsentRequestType = other.getAisConsentRequestType();
        return !(this$aisConsentRequestType == null ? other$aisConsentRequestType != null : !this$aisConsentRequestType.equals(other$aisConsentRequestType));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AccountConsent;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        Xs2aAccountAccess $access = this.getAccess();
        result = result * 59 + ($access == null ? 43 : ((Object)$access).hashCode());
        result = result * 59 + (this.isRecurringIndicator() ? 79 : 97);
        LocalDate $validUntil = this.getValidUntil();
        result = result * 59 + ($validUntil == null ? 43 : ((Object)$validUntil).hashCode());
        result = result * 59 + this.getFrequencyPerDay();
        LocalDate $lastActionDate = this.getLastActionDate();
        result = result * 59 + ($lastActionDate == null ? 43 : ((Object)$lastActionDate).hashCode());
        ConsentStatus $consentStatus = this.getConsentStatus();
        result = result * 59 + ($consentStatus == null ? 43 : $consentStatus.hashCode());
        result = result * 59 + (this.isWithBalance() ? 79 : 97);
        result = result * 59 + (this.isTppRedirectPreferred() ? 79 : 97);
        PsuIdData $psuData = this.getPsuData();
        result = result * 59 + ($psuData == null ? 43 : $psuData.hashCode());
        TppInfo $tppInfo = this.getTppInfo();
        result = result * 59 + ($tppInfo == null ? 43 : $tppInfo.hashCode());
        AisConsentRequestType $aisConsentRequestType = this.getAisConsentRequestType();
        result = result * 59 + ($aisConsentRequestType == null ? 43 : $aisConsentRequestType.hashCode());
        return result;
    }

    public String toString() {
        return "AccountConsent(id=" + this.getId() + ", access=" + this.getAccess() + ", recurringIndicator=" + this.isRecurringIndicator() + ", validUntil=" + this.getValidUntil() + ", frequencyPerDay=" + this.getFrequencyPerDay() + ", lastActionDate=" + this.getLastActionDate() + ", consentStatus=" + this.getConsentStatus() + ", withBalance=" + this.isWithBalance() + ", tppRedirectPreferred=" + this.isTppRedirectPreferred() + ", psuData=" + this.getPsuData() + ", tppInfo=" + this.getTppInfo() + ", aisConsentRequestType=" + this.getAisConsentRequestType() + ")";
    }
}

