/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.domain;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

@ApiModel(description="MessageErrorCode", value="Message error codes and related http response codes.")
public enum MessageErrorCode {
    CERTIFICATE_INVALID(401),
    CERTIFICATE_EXPIRED(401),
    CERTIFICATE_BLOCKED(401),
    CERTIFICATE_REVOKED(401),
    CERTIFICATE_MISSING(401),
    SIGNATURE_INVALID(401),
    SIGNATURE_MISSING(401),
    FORMAT_ERROR(400),
    PSU_CREDENTIALS_INVALID(401),
    CORPORATE_ID_INVALID(401),
    CONSENT_INVALID(401),
    CONSENT_EXPIRED(401),
    TOKEN_UNKNOWN(401),
    TOKEN_INVALID(401),
    TOKEN_EXPIRED(401),
    TIMESTAMP_INVALID(400),
    PERIOD_INVALID(400),
    SCA_METHOD_UNKNOWN(400),
    TRANSACTION_ID_INVALID(400),
    PRODUCT_INVALID(403),
    PRODUCT_UNKNOWN(404),
    PAYMENT_FAILED(400),
    REQUIRED_KID_MISSING(401),
    EXECUTION_DATE_INVALID(400),
    CARD_INVALID(400),
    NO_PIIS_ACTIVATION(400),
    SESSIONS_NOT_SUPPORTED(400),
    ACCESS_EXCEEDED(429),
    REQUESTED_FORMATS_INVALID(401),
    SERVICE_INVALID_401(401){

        @Override
        public String getName() {
            return "SERVICE_INVALID";
        }
    }
    ,
    SERVICE_INVALID_405(405){

        @Override
        public String getName() {
            return "SERVICE_INVALID";
        }
    }
    ,
    SERVICE_BLOCKED(403),
    CONSENT_UNKNOWN_403(403){

        @Override
        public String getName() {
            return "CONSENT_UNKNOWN";
        }
    }
    ,
    CONSENT_UNKNOWN_400(400){

        @Override
        public String getName() {
            return "CONSENT_UNKNOWN";
        }
    }
    ,
    RESOURCE_UNKNOWN_404(404){

        @Override
        public String getName() {
            return "RESOURCE_UNKNOWN";
        }
    }
    ,
    RESOURCE_UNKNOWN_403(403){

        @Override
        public String getName() {
            return "RESOURCE_UNKNOWN";
        }
    }
    ,
    RESOURCE_UNKNOWN_400(400){

        @Override
        public String getName() {
            return "RESOURCE_UNKNOWN";
        }
    }
    ,
    RESOURCE_EXPIRED_403(403){

        @Override
        public String getName() {
            return "RESOURCE_EXPIRED";
        }
    }
    ,
    RESOURCE_EXPIRED_400(400){

        @Override
        public String getName() {
            return "RESOURCE_EXPIRED";
        }
    }
    ,
    PARAMETER_NOT_SUPPORTED(400),
    BEARER_TOKEN_EMPTY(400),
    INTERNAL_SERVER_ERROR(500),
    UNAUTHORIZED(401),
    CONTENT_TYPE_NOT_SUPPORTED(406);

    private static Map<String, MessageErrorCode> container;
    @ApiModelProperty(value="code", example="400")
    private int code;

    @JsonCreator
    private MessageErrorCode(int code) {
        this.code = code;
    }

    public int getCode() {
        return this.code;
    }

    @JsonValue
    public String getName() {
        return this.name();
    }

    @JsonIgnore
    public static Optional<MessageErrorCode> getByName(String name) {
        return Optional.ofNullable(container.get(name));
    }

    static {
        container = new HashMap<String, MessageErrorCode>();
        Arrays.stream(MessageErrorCode.values()).forEach(errorCode -> container.put(errorCode.getName(), (MessageErrorCode)((Object)errorCode)));
    }
}

