/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.domain;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

public enum BalanceType {
    CLOSING_BOOKED("closingBooked"),
    EXPECTED("expected"),
    AUTHORISED("authorised"),
    OPENING_BOOKED("openingBooked"),
    INTERIM_AVAILABLE("interimAvailable"),
    FORWARD_AVAILABLE("forwardAvailable"),
    NONINVOICED("nonInvoiced"),
    AVAILABLE("available");

    private static final Map<String, BalanceType> container;
    private String value;

    private BalanceType(String value) {
        this.value = value;
    }

    public String getValue() {
        return this.value;
    }

    @JsonIgnore
    public static Optional<BalanceType> getByValue(String name) {
        return Optional.ofNullable(container.get(name));
    }

    static {
        container = new HashMap<String, BalanceType>();
        for (BalanceType type : BalanceType.values()) {
            container.put(type.getValue(), type);
        }
    }
}

