/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.config;

import com.fasterxml.jackson.databind.ObjectMapper;
import de.adorsys.psd2.consent.api.service.TppStopListService;
import de.adorsys.psd2.xs2a.component.PaymentTypeEnumConverter;
import de.adorsys.psd2.xs2a.config.CorsConfigurationProperties;
import de.adorsys.psd2.xs2a.config.Xs2aEndpointPathConstant;
import de.adorsys.psd2.xs2a.service.TppService;
import de.adorsys.psd2.xs2a.service.mapper.MessageErrorMapper;
import de.adorsys.psd2.xs2a.service.message.MessageService;
import de.adorsys.psd2.xs2a.service.validator.RequestValidatorService;
import de.adorsys.psd2.xs2a.service.validator.tpp.TppInfoHolder;
import de.adorsys.psd2.xs2a.web.interceptor.HandlerInterceptor;
import de.adorsys.psd2.xs2a.web.interceptor.logging.AccountLoggingInterceptor;
import de.adorsys.psd2.xs2a.web.interceptor.logging.ConsentLoggingInterceptor;
import de.adorsys.psd2.xs2a.web.interceptor.logging.FundsConfirmationLoggingInterceptor;
import de.adorsys.psd2.xs2a.web.interceptor.logging.PaymentLoggingInterceptor;
import de.adorsys.psd2.xs2a.web.interceptor.logging.SigningBasketLoggingInterceptor;
import de.adorsys.psd2.xs2a.web.interceptor.tpp.TppStopListInterceptor;
import java.beans.ConstructorProperties;
import java.util.List;
import javax.validation.Validation;
import javax.validation.Validator;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.MessageSource;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.EnableAspectJAutoProxy;
import org.springframework.context.support.ReloadableResourceBundleMessageSource;
import org.springframework.core.convert.converter.GenericConverter;
import org.springframework.format.FormatterRegistry;
import org.springframework.web.context.annotation.RequestScope;
import org.springframework.web.servlet.config.annotation.CorsRegistry;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.PathMatchConfigurer;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurerAdapter;

@Configuration
@EnableAspectJAutoProxy(proxyTargetClass=true)
public class WebConfig
extends WebMvcConfigurerAdapter {
    @Value(value="${application.ais.transaction.max-length}")
    private int maxNumberOfCharInTransactionJson;
    @Qualifier(value="xs2aCorsConfigProperties")
    private final CorsConfigurationProperties corsConfigurationProperties;
    private final TppService tppService;
    private final TppStopListService tppStopListService;
    private final ObjectMapper objectMapper;

    public void configurePathMatch(PathMatchConfigurer configurer) {
        configurer.setUseSuffixPatternMatch(Boolean.valueOf(false));
    }

    @Bean
    public MessageSource messageSource() {
        ReloadableResourceBundleMessageSource messageSource = new ReloadableResourceBundleMessageSource();
        messageSource.setBasename("classpath:error_message");
        messageSource.setCacheSeconds(3600);
        messageSource.setDefaultEncoding("UTF-8");
        return messageSource;
    }

    @Bean
    public RequestValidatorService requestValidatorService() {
        return new RequestValidatorService();
    }

    public void addInterceptors(InterceptorRegistry registry) {
        registry.addInterceptor((org.springframework.web.servlet.HandlerInterceptor)new AccountLoggingInterceptor(this.tppService)).addPathPatterns(new String[]{"/v1/accounts/**"});
        registry.addInterceptor((org.springframework.web.servlet.HandlerInterceptor)new ConsentLoggingInterceptor(this.tppService)).addPathPatterns(new String[]{"/v1/consents/**"});
        registry.addInterceptor((org.springframework.web.servlet.HandlerInterceptor)new FundsConfirmationLoggingInterceptor(this.tppService)).addPathPatterns(new String[]{"/v1/funds-confirmations/**"});
        registry.addInterceptor((org.springframework.web.servlet.HandlerInterceptor)new PaymentLoggingInterceptor(this.tppService)).addPathPatterns(new String[]{"/v1/payments/**", "/v1/bulk-payments/**", "/v1/periodic-payments/**"});
        registry.addInterceptor((org.springframework.web.servlet.HandlerInterceptor)new SigningBasketLoggingInterceptor(this.tppService)).addPathPatterns(new String[]{"/v1/signing-baskets/**"});
        registry.addInterceptor((org.springframework.web.servlet.HandlerInterceptor)new TppStopListInterceptor(this.tppService, this.tppStopListService, this.objectMapper)).addPathPatterns(Xs2aEndpointPathConstant.getAllXs2aEndpointPaths());
        registry.addInterceptor((org.springframework.web.servlet.HandlerInterceptor)new HandlerInterceptor(this.requestValidatorService(), this.objectMapper, this.messageErrorMapper())).addPathPatterns(Xs2aEndpointPathConstant.getAllXs2aEndpointPaths());
    }

    @Bean
    public int maxNumberOfCharInTransactionJson() {
        return this.maxNumberOfCharInTransactionJson;
    }

    @Bean
    public Validator validator() {
        return Validation.buildDefaultValidatorFactory().getValidator();
    }

    public void addCorsMappings(CorsRegistry registry) {
        registry.addMapping("/v1/**").allowCredentials(this.corsConfigurationProperties.getAllowCredentials().booleanValue()).allowedOrigins(this.getTargetParameters(this.corsConfigurationProperties.getAllowedOrigins())).allowedHeaders(this.getTargetParameters(this.corsConfigurationProperties.getAllowedHeaders())).allowedMethods(this.getTargetParameters(this.corsConfigurationProperties.getAllowedMethods())).maxAge(this.corsConfigurationProperties.getMaxAge());
    }

    private String[] getTargetParameters(List<String> targetParameters) {
        return targetParameters.toArray(new String[0]);
    }

    @Bean
    @RequestScope
    public TppInfoHolder getTppInfoHolder() {
        return new TppInfoHolder();
    }

    @Bean
    public MessageErrorMapper messageErrorMapper() {
        return new MessageErrorMapper(new MessageService(this.messageSource()));
    }

    public void addFormatters(FormatterRegistry registry) {
        registry.addConverter((GenericConverter)new PaymentTypeEnumConverter());
    }

    @ConstructorProperties(value={"corsConfigurationProperties", "tppService", "tppStopListService", "objectMapper"})
    public WebConfig(CorsConfigurationProperties corsConfigurationProperties, TppService tppService, TppStopListService tppStopListService, ObjectMapper objectMapper) {
        this.corsConfigurationProperties = corsConfigurationProperties;
        this.tppService = tppService;
        this.tppStopListService = tppStopListService;
        this.objectMapper = objectMapper;
    }
}

