/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.config;

import de.adorsys.psd2.xs2a.config.factory.AisScaStageAuthorisationFactory;
import de.adorsys.psd2.xs2a.core.profile.ScaApproach;
import de.adorsys.psd2.xs2a.service.authorization.ais.AisAuthorizationService;
import de.adorsys.psd2.xs2a.service.authorization.ais.DecoupledAisAuthorizationService;
import de.adorsys.psd2.xs2a.service.authorization.ais.EmbeddedAisAuthorizationService;
import de.adorsys.psd2.xs2a.service.authorization.ais.OauthAisAuthorizationService;
import de.adorsys.psd2.xs2a.service.authorization.ais.RedirectAisAuthorizationService;
import de.adorsys.psd2.xs2a.service.authorization.pis.DecoupledPisScaAuthorisationService;
import de.adorsys.psd2.xs2a.service.authorization.pis.EmbeddedPisScaAuthorisationService;
import de.adorsys.psd2.xs2a.service.authorization.pis.OauthPisScaAuthorisationService;
import de.adorsys.psd2.xs2a.service.authorization.pis.PisAuthorisationService;
import de.adorsys.psd2.xs2a.service.authorization.pis.PisScaAuthorisationService;
import de.adorsys.psd2.xs2a.service.authorization.pis.RedirectPisScaAuthorisationService;
import de.adorsys.psd2.xs2a.service.consent.Xs2aAisConsentService;
import de.adorsys.psd2.xs2a.service.mapper.consent.Xs2aAisConsentMapper;
import de.adorsys.psd2.xs2a.service.mapper.consent.Xs2aPisCommonPaymentMapper;
import de.adorsys.psd2.xs2a.service.payment.DecoupedScaPaymentService;
import de.adorsys.psd2.xs2a.service.payment.EmbeddedScaPaymentService;
import de.adorsys.psd2.xs2a.service.payment.OauthScaPaymentService;
import de.adorsys.psd2.xs2a.service.payment.RedirectScaPaymentService;
import de.adorsys.psd2.xs2a.service.payment.ScaPaymentService;
import de.adorsys.psd2.xs2a.service.profile.AspspProfileServiceWrapper;
import java.beans.ConstructorProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class ScaAuthorizationConfig {
    private final AspspProfileServiceWrapper aspspProfileService;

    @Bean
    public ScaPaymentService scaPaymentService(OauthScaPaymentService oauthScaPaymentService, RedirectScaPaymentService redirectScaPaymentService, EmbeddedScaPaymentService embeddedScaPaymentService, DecoupedScaPaymentService decoupedScaPaymentService) {
        ScaApproach scaApproach = this.getScaApproach();
        if (ScaApproach.OAUTH == scaApproach) {
            return oauthScaPaymentService;
        }
        if (ScaApproach.DECOUPLED == scaApproach) {
            return decoupedScaPaymentService;
        }
        if (ScaApproach.EMBEDDED == scaApproach) {
            return embeddedScaPaymentService;
        }
        return redirectScaPaymentService;
    }

    @Bean
    public AisAuthorizationService aisAuthorizationService(Xs2aAisConsentService aisConsentService, Xs2aAisConsentMapper aisConsentMapper, AisScaStageAuthorisationFactory scaStageAuthorisationFactory) {
        switch (this.getScaApproach()) {
            case OAUTH: {
                return new OauthAisAuthorizationService();
            }
            case DECOUPLED: {
                return new DecoupledAisAuthorizationService();
            }
            case EMBEDDED: {
                return new EmbeddedAisAuthorizationService(aisConsentService, aisConsentMapper, scaStageAuthorisationFactory);
            }
        }
        return new RedirectAisAuthorizationService(aisConsentService);
    }

    @Bean
    public PisScaAuthorisationService pisAuthorizationService(PisAuthorisationService authorisationService, Xs2aPisCommonPaymentMapper pisCommonPaymentMapper) {
        ScaApproach scaApproach = this.getScaApproach();
        if (ScaApproach.OAUTH == scaApproach) {
            return new OauthPisScaAuthorisationService();
        }
        if (ScaApproach.DECOUPLED == scaApproach) {
            return new DecoupledPisScaAuthorisationService();
        }
        if (ScaApproach.EMBEDDED == scaApproach) {
            return new EmbeddedPisScaAuthorisationService(authorisationService, pisCommonPaymentMapper);
        }
        return new RedirectPisScaAuthorisationService(authorisationService, pisCommonPaymentMapper);
    }

    private ScaApproach getScaApproach() {
        return this.aspspProfileService.getScaApproach();
    }

    @ConstructorProperties(value={"aspspProfileService"})
    public ScaAuthorizationConfig(AspspProfileServiceWrapper aspspProfileService) {
        this.aspspProfileService = aspspProfileService;
    }
}

