/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.web.mapper;

import com.fasterxml.jackson.databind.ObjectMapper;
import de.adorsys.psd2.model.AuthenticationObject;
import de.adorsys.psd2.model.AuthenticationType;
import de.adorsys.psd2.model.BulkPaymentInitiationTarget2WithStatusResponse;
import de.adorsys.psd2.model.ChosenScaMethod;
import de.adorsys.psd2.model.DayOfExecution;
import de.adorsys.psd2.model.ExecutionRule;
import de.adorsys.psd2.model.FrequencyCode;
import de.adorsys.psd2.model.PaymentInitationRequestResponse201;
import de.adorsys.psd2.model.PaymentInitiationCancelResponse200202;
import de.adorsys.psd2.model.PaymentInitiationStatusResponse200Json;
import de.adorsys.psd2.model.PaymentInitiationTarget2Json;
import de.adorsys.psd2.model.PaymentInitiationTarget2WithStatusResponse;
import de.adorsys.psd2.model.PeriodicPaymentInitiationTarget2WithStatusResponse;
import de.adorsys.psd2.model.ScaMethods;
import de.adorsys.psd2.xs2a.core.pis.TransactionStatus;
import de.adorsys.psd2.xs2a.core.profile.PaymentProduct;
import de.adorsys.psd2.xs2a.core.profile.PaymentType;
import de.adorsys.psd2.xs2a.core.psu.PsuIdData;
import de.adorsys.psd2.xs2a.domain.consent.Xs2aAuthenticationObject;
import de.adorsys.psd2.xs2a.domain.consent.Xs2aChosenScaMethod;
import de.adorsys.psd2.xs2a.domain.pis.BulkPayment;
import de.adorsys.psd2.xs2a.domain.pis.CancelPaymentResponse;
import de.adorsys.psd2.xs2a.domain.pis.PaymentInitiationParameters;
import de.adorsys.psd2.xs2a.domain.pis.PaymentInitiationResponse;
import de.adorsys.psd2.xs2a.domain.pis.PeriodicPayment;
import de.adorsys.psd2.xs2a.domain.pis.SinglePayment;
import de.adorsys.psd2.xs2a.service.mapper.AccountModelMapper;
import de.adorsys.psd2.xs2a.service.mapper.AmountModelMapper;
import de.adorsys.psd2.xs2a.service.mapper.MessageErrorMapper;
import de.adorsys.psd2.xs2a.web.mapper.CoreObjectsMapper;
import java.beans.ConstructorProperties;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.stereotype.Component;

@Component
public class PaymentModelMapperPsd2 {
    private final ObjectMapper mapper;
    private final CoreObjectsMapper coreObjectsMapper;
    private final MessageErrorMapper messageErrorMapper;
    private final AccountModelMapper accountModelMapper;

    public Object mapToGetPaymentResponse12(Object payment, PaymentType type, PaymentProduct product) {
        if (type == PaymentType.SINGLE) {
            SinglePayment xs2aPayment = (SinglePayment)payment;
            PaymentInitiationTarget2WithStatusResponse paymentResponse = new PaymentInitiationTarget2WithStatusResponse();
            paymentResponse.setEndToEndIdentification(xs2aPayment.getEndToEndIdentification());
            paymentResponse.setDebtorAccount(this.accountModelMapper.mapToAccountReference12(xs2aPayment.getDebtorAccount()));
            paymentResponse.setInstructedAmount(AmountModelMapper.mapToAmount(xs2aPayment.getInstructedAmount()));
            paymentResponse.setCreditorAccount(this.accountModelMapper.mapToAccountReference12(xs2aPayment.getCreditorAccount()));
            paymentResponse.setCreditorAgent(xs2aPayment.getCreditorAgent());
            paymentResponse.setCreditorName(xs2aPayment.getCreditorName());
            paymentResponse.setCreditorAddress(this.accountModelMapper.mapToAddress12(xs2aPayment.getCreditorAddress()));
            paymentResponse.setRemittanceInformationUnstructured(xs2aPayment.getRemittanceInformationUnstructured());
            paymentResponse.setTransactionStatus(PaymentModelMapperPsd2.mapToTransactionStatus12(xs2aPayment.getTransactionStatus()));
            return paymentResponse;
        }
        if (type == PaymentType.PERIODIC) {
            PeriodicPayment xs2aPayment = (PeriodicPayment)payment;
            PeriodicPaymentInitiationTarget2WithStatusResponse paymentResponse = new PeriodicPaymentInitiationTarget2WithStatusResponse();
            paymentResponse.setEndToEndIdentification(xs2aPayment.getEndToEndIdentification());
            paymentResponse.setDebtorAccount(this.accountModelMapper.mapToAccountReference12(xs2aPayment.getDebtorAccount()));
            paymentResponse.setInstructedAmount(AmountModelMapper.mapToAmount(xs2aPayment.getInstructedAmount()));
            paymentResponse.setCreditorAccount(this.accountModelMapper.mapToAccountReference12(xs2aPayment.getCreditorAccount()));
            paymentResponse.setCreditorAgent(xs2aPayment.getCreditorAgent());
            paymentResponse.setCreditorName(xs2aPayment.getCreditorName());
            paymentResponse.setCreditorAddress(this.accountModelMapper.mapToAddress12(xs2aPayment.getCreditorAddress()));
            paymentResponse.setRemittanceInformationUnstructured(xs2aPayment.getRemittanceInformationUnstructured());
            paymentResponse.setStartDate(xs2aPayment.getStartDate());
            paymentResponse.setEndDate(xs2aPayment.getEndDate());
            paymentResponse.setExecutionRule(ExecutionRule.fromValue((String)xs2aPayment.getExecutionRule()));
            paymentResponse.setFrequency(FrequencyCode.valueOf((String)xs2aPayment.getFrequency().name()));
            String executionDateString = String.format("%02d", xs2aPayment.getDayOfExecution());
            paymentResponse.setDayOfExecution(DayOfExecution.fromValue((String)executionDateString));
            paymentResponse.setTransactionStatus(PaymentModelMapperPsd2.mapToTransactionStatus12(xs2aPayment.getTransactionStatus()));
            return paymentResponse;
        }
        BulkPayment xs2aPayment = (BulkPayment)payment;
        BulkPaymentInitiationTarget2WithStatusResponse paymentResponse = new BulkPaymentInitiationTarget2WithStatusResponse();
        paymentResponse.setBatchBookingPreferred(xs2aPayment.getBatchBookingPreferred());
        paymentResponse.setRequestedExecutionDate(xs2aPayment.getRequestedExecutionDate());
        paymentResponse.setDebtorAccount(this.accountModelMapper.mapToAccountReference12(xs2aPayment.getDebtorAccount()));
        paymentResponse.setPayments(this.mapToBulkPartList12(xs2aPayment.getPayments()));
        paymentResponse.setTransactionStatus(PaymentModelMapperPsd2.mapToTransactionStatus12(xs2aPayment.getTransactionStatus()));
        return paymentResponse;
    }

    public static PaymentInitiationStatusResponse200Json mapToStatusResponse12(TransactionStatus status) {
        return new PaymentInitiationStatusResponse200Json().transactionStatus(PaymentModelMapperPsd2.mapToTransactionStatus12(status));
    }

    public static de.adorsys.psd2.model.TransactionStatus mapToTransactionStatus12(TransactionStatus responseObject) {
        return Optional.ofNullable(responseObject).map(r -> de.adorsys.psd2.model.TransactionStatus.valueOf((String)r.name())).orElse(null);
    }

    public Object mapToPaymentInitiationResponse12(Object response) {
        PaymentInitationRequestResponse201 response201 = new PaymentInitationRequestResponse201();
        PaymentInitiationResponse specificResponse = (PaymentInitiationResponse)response;
        response201.setTransactionStatus(PaymentModelMapperPsd2.mapToTransactionStatus12(specificResponse.getTransactionStatus()));
        response201.setPaymentId(specificResponse.getPaymentId());
        response201.setTransactionFees(AmountModelMapper.mapToAmount(specificResponse.getTransactionFees()));
        response201.setTransactionFeeIndicator(Boolean.valueOf(specificResponse.isTransactionFeeIndicator()));
        response201.setScaMethods(this.mapToScaMethods(specificResponse.getScaMethods()));
        response201.setChallengeData(this.coreObjectsMapper.mapToChallengeData(specificResponse.getChallengeData()));
        response201.setLinks((Map)this.mapper.convertValue((Object)((PaymentInitiationResponse)response).getLinks(), Map.class));
        response201.setPsuMessage(specificResponse.getPsuMessage());
        response201.setTppMessages(this.messageErrorMapper.mapToTppMessages(specificResponse.getTppMessages()));
        return response201;
    }

    private List<PaymentInitiationTarget2Json> mapToBulkPartList12(List<SinglePayment> payments) {
        return payments.stream().map(this::mapToBulkPart12).collect(Collectors.toList());
    }

    private PaymentInitiationTarget2Json mapToBulkPart12(SinglePayment payment) {
        PaymentInitiationTarget2Json bulkPart = new PaymentInitiationTarget2Json().endToEndIdentification(payment.getEndToEndIdentification());
        bulkPart.setDebtorAccount(this.accountModelMapper.mapToAccountReference12(payment.getDebtorAccount()));
        bulkPart.setInstructedAmount(AmountModelMapper.mapToAmount(payment.getInstructedAmount()));
        bulkPart.setCreditorAccount(this.accountModelMapper.mapToAccountReference12(payment.getCreditorAccount()));
        bulkPart.setCreditorAgent(payment.getCreditorAgent());
        bulkPart.setCreditorName(payment.getCreditorName());
        bulkPart.setCreditorAddress(this.accountModelMapper.mapToAddress12(payment.getCreditorAddress()));
        bulkPart.setRemittanceInformationUnstructured(payment.getRemittanceInformationUnstructured());
        return bulkPart;
    }

    public PaymentInitiationParameters mapToPaymentRequestParameters(String paymentProduct, String paymentService, byte[] tpPSignatureCertificate, String tpPRedirectURI, String tpPNokRedirectURI, boolean tppExplicitAuthorisationPreferred, PsuIdData psuData) {
        PaymentInitiationParameters parameters = new PaymentInitiationParameters();
        parameters.setPaymentType((PaymentType)PaymentType.getByValue((String)paymentService).orElseThrow(() -> new IllegalArgumentException("Unsupported payment service")));
        parameters.setPaymentProduct((PaymentProduct)PaymentProduct.getByValue((String)paymentProduct).orElseThrow(() -> new IllegalArgumentException("Unsupported payment product")));
        parameters.setQwacCertificate(new String(Optional.ofNullable(tpPSignatureCertificate).orElse(new byte[0]), StandardCharsets.UTF_8));
        parameters.setTppRedirectUri(tpPRedirectURI);
        parameters.setTppNokRedirectUri(tpPNokRedirectURI);
        parameters.setTppExplicitAuthorisationPreferred(tppExplicitAuthorisationPreferred);
        parameters.setPsuData(psuData);
        return parameters;
    }

    public PaymentInitiationCancelResponse200202 mapToPaymentInitiationCancelResponse(CancelPaymentResponse cancelPaymentResponse) {
        PaymentInitiationCancelResponse200202 response = new PaymentInitiationCancelResponse200202();
        response.setTransactionStatus(PaymentModelMapperPsd2.mapToTransactionStatus12(cancelPaymentResponse.getTransactionStatus()));
        response.setScaMethods(this.mapToScaMethods(cancelPaymentResponse.getScaMethods()));
        response.setChosenScaMethod(this.mapToChosenScaMethod(cancelPaymentResponse.getChosenScaMethod()));
        response.setChallengeData(this.coreObjectsMapper.mapToChallengeData(cancelPaymentResponse.getChallengeData()));
        response._links((Map)this.mapper.convertValue((Object)cancelPaymentResponse.getLinks(), Map.class));
        return response;
    }

    private ScaMethods mapToScaMethods(Xs2aAuthenticationObject ... authenticationObjects) {
        return Optional.ofNullable(authenticationObjects).map(objects -> {
            ScaMethods scaMethods = new ScaMethods();
            Arrays.stream(objects).map(this::mapToAuthenticationObject).filter(Objects::nonNull).forEach(arg_0 -> scaMethods.add(arg_0));
            return scaMethods;
        }).orElse(null);
    }

    private AuthenticationObject mapToAuthenticationObject(Xs2aAuthenticationObject xs2aAuthenticationObject) {
        return Optional.ofNullable(xs2aAuthenticationObject).map(a -> {
            AuthenticationObject psd2Authentication = new AuthenticationObject();
            psd2Authentication.setAuthenticationType(AuthenticationType.fromValue((String)a.getAuthenticationType()));
            psd2Authentication.setAuthenticationVersion(a.getAuthenticationVersion());
            psd2Authentication.setAuthenticationMethodId(a.getAuthenticationMethodId());
            psd2Authentication.setName(a.getName());
            psd2Authentication.setExplanation(a.getExplanation());
            return psd2Authentication;
        }).orElse(null);
    }

    private ChosenScaMethod mapToChosenScaMethod(Xs2aChosenScaMethod xs2aChosenScaMethod) {
        return Optional.ofNullable(xs2aChosenScaMethod).map(ch -> {
            ChosenScaMethod method = new ChosenScaMethod();
            method.setAuthenticationMethodId(ch.getAuthenticationMethodId());
            method.setAuthenticationType(AuthenticationType.fromValue((String)ch.getAuthenticationType()));
            return method;
        }).orElse(null);
    }

    @ConstructorProperties(value={"mapper", "coreObjectsMapper", "messageErrorMapper", "accountModelMapper"})
    public PaymentModelMapperPsd2(ObjectMapper mapper, CoreObjectsMapper coreObjectsMapper, MessageErrorMapper messageErrorMapper, AccountModelMapper accountModelMapper) {
        this.mapper = mapper;
        this.coreObjectsMapper = coreObjectsMapper;
        this.messageErrorMapper = messageErrorMapper;
        this.accountModelMapper = accountModelMapper;
    }
}

