/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.web.interceptor;

import com.fasterxml.jackson.databind.ObjectMapper;
import de.adorsys.psd2.model.TppMessages;
import de.adorsys.psd2.xs2a.domain.MessageErrorCode;
import de.adorsys.psd2.xs2a.service.mapper.MessageErrorMapper;
import de.adorsys.psd2.xs2a.service.validator.RequestValidatorService;
import java.beans.ConstructorProperties;
import java.io.IOException;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.web.servlet.handler.HandlerInterceptorAdapter;

@Component
public class HandlerInterceptor
extends HandlerInterceptorAdapter {
    private static final Logger log = LoggerFactory.getLogger(HandlerInterceptor.class);
    private final RequestValidatorService requestValidatorService;
    private final ObjectMapper objectMapper;
    private final MessageErrorMapper messageErrorMapper;

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws IOException {
        return this.isRequestValidAndSendRespIfError(request, response, handler);
    }

    private boolean isRequestValidAndSendRespIfError(HttpServletRequest request, HttpServletResponse response, Object handler) throws IOException {
        Map<String, String> violationsMap = this.requestValidatorService.getRequestViolationMap(request, handler);
        if (violationsMap.isEmpty()) {
            return true;
        }
        Map.Entry<String, String> firstError = violationsMap.entrySet().iterator().next();
        MessageErrorCode messageCode = this.getActualMessageErrorCode(firstError.getKey());
        log.debug("Handled error {}", (Object)(messageCode.name() + ": " + firstError.getValue()));
        response.resetBuffer();
        response.setStatus(messageCode.getCode());
        response.setCharacterEncoding("UTF-8");
        response.setHeader("Content-Type", "application/json");
        response.getWriter().write(this.objectMapper.writeValueAsString((Object)this.getTppMessages(messageCode)));
        response.flushBuffer();
        return false;
    }

    private MessageErrorCode getActualMessageErrorCode(String error) {
        return MessageErrorCode.getByName(error).orElse(MessageErrorCode.FORMAT_ERROR);
    }

    private TppMessages getTppMessages(MessageErrorCode errorCode) {
        return this.messageErrorMapper.mapToTppMessages(errorCode);
    }

    @ConstructorProperties(value={"requestValidatorService", "objectMapper", "messageErrorMapper"})
    public HandlerInterceptor(RequestValidatorService requestValidatorService, ObjectMapper objectMapper, MessageErrorMapper messageErrorMapper) {
        this.requestValidatorService = requestValidatorService;
        this.objectMapper = objectMapper;
        this.messageErrorMapper = messageErrorMapper;
    }
}

