/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.web.filter;

import de.adorsys.psd2.validator.certificate.CertificateErrorMsgCode;
import de.adorsys.psd2.validator.signature.TppSignatureValidator;
import de.adorsys.psd2.xs2a.service.profile.AspspProfileServiceWrapper;
import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.security.SignatureException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SignatureFilter
implements Filter {
    private static final Logger log = LoggerFactory.getLogger(SignatureFilter.class);
    @Autowired
    private AspspProfileServiceWrapper aspspProfileService;

    public void init(FilterConfig filterConfig) {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (this.aspspProfileService.getTppSignatureRequired().booleanValue()) {
            if (!(request instanceof HttpServletRequest) || !(response instanceof HttpServletResponse)) {
                throw new ServletException("OncePerRequestFilter just supports HTTP requests");
            }
            HttpServletRequest httpRequest = (HttpServletRequest)request;
            String signature = httpRequest.getHeader("signature");
            if (StringUtils.isBlank((CharSequence)signature)) {
                ((HttpServletResponse)response).sendError(401, CertificateErrorMsgCode.SIGNATURE_MISSING.toString());
                return;
            }
            if (this.digestContainsErrors(httpRequest)) {
                ((HttpServletResponse)response).sendError(400, CertificateErrorMsgCode.FORMAT_ERROR.toString());
                return;
            }
            Map<String, String> headers = this.obtainRequestHeaders(httpRequest);
            String encodedTppCert = httpRequest.getHeader("tpp-signature-certificate");
            TppSignatureValidator tppSignatureValidator = new TppSignatureValidator();
            try {
                if (!tppSignatureValidator.verifySignature(signature, encodedTppCert, headers)) {
                    ((HttpServletResponse)response).sendError(401, CertificateErrorMsgCode.SIGNATURE_INVALID.toString());
                    return;
                }
                chain.doFilter(request, response);
            }
            catch (NoSuchAlgorithmException | SignatureException e) {
                log.debug(e.getMessage());
                ((HttpServletResponse)response).sendError(401, CertificateErrorMsgCode.SIGNATURE_INVALID.toString());
                return;
            }
        } else {
            chain.doFilter(request, response);
        }
    }

    private boolean digestContainsErrors(HttpServletRequest httpRequest) {
        String digest = httpRequest.getHeader("digest");
        return StringUtils.isBlank((CharSequence)digest) || !Arrays.asList(64, 128).contains(digest.getBytes().length);
    }

    public void destroy() {
    }

    private Map<String, String> obtainRequestHeaders(HttpServletRequest request) {
        return Collections.list(request.getHeaderNames()).stream().collect(Collectors.toMap(Function.identity(), arg_0 -> ((HttpServletRequest)request).getHeader(arg_0)));
    }
}

