/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.web.filter;

import de.adorsys.psd2.validator.certificate.util.CertificateExtractorUtil;
import de.adorsys.psd2.validator.certificate.util.TppCertificateData;
import de.adorsys.psd2.xs2a.core.tpp.TppInfo;
import de.adorsys.psd2.xs2a.core.tpp.TppRole;
import java.io.IOException;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import no.difi.certvalidator.api.CertificateValidationException;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Profile;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Component;
import org.springframework.web.filter.GenericFilterBean;

@Profile(value={"default"})
@Component
public class QwacCertificateFilter
extends GenericFilterBean {
    private static final Logger log = LoggerFactory.getLogger(QwacCertificateFilter.class);

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest httpRequest;
        String encodedTppQwacCert;
        if (!(request instanceof HttpServletRequest) || !(response instanceof HttpServletResponse)) {
            throw new ServletException("OncePerRequestFilter just supports HTTP requests");
        }
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        if (Objects.isNull(authentication) && StringUtils.isNotBlank((CharSequence)(encodedTppQwacCert = this.getEncodedTppQwacCert(httpRequest = (HttpServletRequest)request)))) {
            try {
                TppCertificateData tppCertificateData = CertificateExtractorUtil.extract((String)encodedTppQwacCert);
                TppInfo tppInfo = new TppInfo();
                tppInfo.setAuthorisationNumber(tppCertificateData.getPspAuthorisationNumber());
                tppInfo.setTppName(tppCertificateData.getName());
                tppInfo.setAuthorityId(tppCertificateData.getPspAuthorityId());
                tppInfo.setAuthorityName(tppCertificateData.getPspAuthorityName());
                tppInfo.setCountry(tppCertificateData.getCountry());
                tppInfo.setOrganisation(tppCertificateData.getOrganisation());
                tppInfo.setOrganisationUnit(tppCertificateData.getOrganisationUnit());
                tppInfo.setCity(tppCertificateData.getCity());
                tppInfo.setState(tppCertificateData.getState());
                List tppRoles = tppCertificateData.getPspRoles();
                List xs2aTppRoles = tppRoles.stream().map(role -> TppRole.valueOf((String)role.name())).collect(Collectors.toList());
                tppInfo.setTppRoles(xs2aTppRoles);
                List authorities = tppRoles.stream().map(role -> new SimpleGrantedAuthority("ROLE_" + role.name())).collect(Collectors.toList());
                UsernamePasswordAuthenticationToken authenticationToken = new UsernamePasswordAuthenticationToken((Object)tppCertificateData.getPspAuthorisationNumber(), (Object)tppInfo, authorities);
                SecurityContextHolder.getContext().setAuthentication((Authentication)authenticationToken);
            }
            catch (CertificateValidationException e) {
                log.debug(e.getMessage());
                ((HttpServletResponse)response).sendError(401, e.getMessage());
                return;
            }
        }
        chain.doFilter(request, response);
    }

    public void destroy() {
    }

    public String getEncodedTppQwacCert(HttpServletRequest httpRequest) {
        return httpRequest.getHeader("tpp-qwac-certificate");
    }
}

