/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.web.aspect;

import de.adorsys.psd2.xs2a.core.profile.PaymentType;
import de.adorsys.psd2.xs2a.domain.Links;
import de.adorsys.psd2.xs2a.domain.ResponseObject;
import de.adorsys.psd2.xs2a.domain.pis.CancelPaymentResponse;
import de.adorsys.psd2.xs2a.service.message.MessageService;
import de.adorsys.psd2.xs2a.service.profile.AspspProfileServiceWrapper;
import de.adorsys.psd2.xs2a.web.PaymentController;
import de.adorsys.psd2.xs2a.web.aspect.AbstractLinkAspect;
import org.aspectj.lang.annotation.AfterReturning;
import org.aspectj.lang.annotation.Aspect;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class PaymentCancellationAspect
extends AbstractLinkAspect<PaymentController> {
    public PaymentCancellationAspect(AspspProfileServiceWrapper aspspProfileService, MessageService messageService) {
        super(aspspProfileService, messageService);
    }

    @AfterReturning(pointcut="execution(* de.adorsys.psd2.xs2a.service.PaymentService.cancelPayment(..)) && args( paymentType, paymentId)", returning="result", argNames="result,paymentType,paymentId")
    public ResponseObject<CancelPaymentResponse> cancelPayment(ResponseObject<CancelPaymentResponse> result, PaymentType paymentType, String paymentId) {
        if (!result.hasError()) {
            CancelPaymentResponse response = result.getBody();
            response.setLinks(this.buildCancellationLinks(response.isStartAuthorisationRequired(), paymentType, paymentId));
            return result;
        }
        return this.enrichErrorTextMessage(result);
    }

    private Links buildCancellationLinks(boolean startAuthorisationRequired, PaymentType paymentType, String paymentId) {
        Links links = new Links();
        if (startAuthorisationRequired) {
            links.setStartAuthorisation(this.buildPath("/v1/{payment-service}/{payment-id}/cancellation-authorisations", paymentType.getValue(), paymentId));
            links.setSelf(this.buildPath("/v1/{payment-service}/{payment-id}", paymentType.getValue(), paymentId));
            links.setStatus(this.buildPath("/v1/{payment-service}/{payment-id}/status", paymentType.getValue(), paymentId));
        }
        return links;
    }
}

