/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.web.aspect;

import de.adorsys.psd2.xs2a.core.profile.PaymentType;
import de.adorsys.psd2.xs2a.core.psu.PsuIdData;
import de.adorsys.psd2.xs2a.domain.Links;
import de.adorsys.psd2.xs2a.domain.ResponseObject;
import de.adorsys.psd2.xs2a.domain.consent.Xsa2CreatePisConsentAuthorisationResponse;
import de.adorsys.psd2.xs2a.service.message.MessageService;
import de.adorsys.psd2.xs2a.service.profile.AspspProfileServiceWrapper;
import de.adorsys.psd2.xs2a.web.PaymentController;
import de.adorsys.psd2.xs2a.web.aspect.AbstractLinkAspect;
import org.aspectj.lang.annotation.AfterReturning;
import org.aspectj.lang.annotation.Aspect;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class CreatePisAuthorizationAspect
extends AbstractLinkAspect<PaymentController> {
    private static final Logger log = LoggerFactory.getLogger(CreatePisAuthorizationAspect.class);

    public CreatePisAuthorizationAspect(AspspProfileServiceWrapper aspspProfileService, MessageService messageService) {
        super(aspspProfileService, messageService);
    }

    @AfterReturning(pointcut="execution(* de.adorsys.psd2.xs2a.service.ConsentService.createPisConsentAuthorization(..)) && args(paymentId, paymentType, psuData)", returning="result", argNames="result,paymentId,paymentType,psuData")
    public ResponseObject<Xsa2CreatePisConsentAuthorisationResponse> createPisConsentAuthorizationAspect(ResponseObject<Xsa2CreatePisConsentAuthorisationResponse> result, String paymentId, PaymentType paymentType, PsuIdData psuData) {
        if (!result.hasError()) {
            Xsa2CreatePisConsentAuthorisationResponse body = result.getBody();
            body.setLinks(this.buildLink(paymentType.getValue(), paymentId, body.getAuthorizationId()));
            return result;
        }
        return this.enrichErrorTextMessage(result);
    }

    private Links buildLink(String paymentService, String paymentId, String authorizationId) {
        Links links = new Links();
        links.setSelf(this.buildPath("/v1/{payment-service}/{payment-id}", paymentService, paymentId));
        links.setStatus(this.buildPath("/v1/{payment-service}/{payment-id}/status", paymentService, paymentId));
        links.setStartAuthorisationWithPsuAuthentication(this.buildPath("/v1/{paymentService}/{paymentId}/authorisations/{authorizationId}", paymentService, paymentId, authorizationId));
        return links;
    }
}

