/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.web.aspect;

import de.adorsys.psd2.xs2a.core.profile.PaymentType;
import de.adorsys.psd2.xs2a.core.profile.ScaApproach;
import de.adorsys.psd2.xs2a.domain.Links;
import de.adorsys.psd2.xs2a.domain.ResponseObject;
import de.adorsys.psd2.xs2a.domain.consent.Xs2aCreatePisConsentCancellationAuthorisationResponse;
import de.adorsys.psd2.xs2a.service.message.MessageService;
import de.adorsys.psd2.xs2a.service.profile.AspspProfileServiceWrapper;
import de.adorsys.psd2.xs2a.web.PaymentController;
import de.adorsys.psd2.xs2a.web.aspect.AbstractLinkAspect;
import org.aspectj.lang.annotation.AfterReturning;
import org.aspectj.lang.annotation.Aspect;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class CreatePisAuthorisationCancellationAspect
extends AbstractLinkAspect<PaymentController> {
    private static final Logger log = LoggerFactory.getLogger(CreatePisAuthorisationCancellationAspect.class);

    public CreatePisAuthorisationCancellationAspect(AspspProfileServiceWrapper aspspProfileService, MessageService messageService) {
        super(aspspProfileService, messageService);
    }

    @AfterReturning(pointcut="execution(* de.adorsys.psd2.xs2a.service.ConsentService.createPisConsentCancellationAuthorization(..)) && args( paymentId, paymentType)", returning="result", argNames="result,paymentId,paymentType")
    public ResponseObject<Xs2aCreatePisConsentCancellationAuthorisationResponse> createPisConsentAuthorizationAspect(ResponseObject<Xs2aCreatePisConsentCancellationAuthorisationResponse> result, String paymentId, PaymentType paymentType) {
        if (!result.hasError()) {
            Xs2aCreatePisConsentCancellationAuthorisationResponse body = result.getBody();
            body.setLinks(this.buildLink(paymentType.getValue(), paymentId, body.getAuthorizationId()));
            return result;
        }
        return this.enrichErrorTextMessage(result);
    }

    private Links buildLink(String paymentService, String paymentId, String authorizationId) {
        Links links = new Links();
        links.setSelf(this.buildPath("/v1/{payment-service}/{payment-id}", paymentService, paymentId));
        links.setStatus(this.buildPath("/v1/{payment-service}/{payment-id}/status", paymentService, paymentId));
        if (this.aspspProfileService.getScaApproach() == ScaApproach.EMBEDDED) {
            return this.addEmbeddedRelatedLinks(links, paymentService, paymentId, authorizationId);
        }
        if (this.aspspProfileService.getScaApproach() == ScaApproach.REDIRECT) {
            return this.addRedirectRelatedLinks(links, paymentService, paymentId, authorizationId);
        }
        if (this.aspspProfileService.getScaApproach() == ScaApproach.OAUTH) {
            links.setScaOAuth("scaOAuth");
        }
        return links;
    }

    private Links addEmbeddedRelatedLinks(Links links, String paymentService, String paymentId, String authorizationId) {
        links.setStartAuthorisationWithPsuAuthentication(this.buildPath("/v1/{paymentService}/{paymentId}/cancellation-authorisations/{authorizationId}", paymentService, paymentId, authorizationId));
        return links;
    }

    private Links addRedirectRelatedLinks(Links links, String paymentService, String paymentId, String authorizationId) {
        String link = this.aspspProfileService.getPisRedirectUrlToAspsp() + paymentId + "/" + paymentId;
        links.setScaRedirect(link);
        links.setScaStatus(this.buildPath("/v1/{payment-service}/{payment-id}/authorisations/{authorisation-id}", paymentService, paymentId, authorizationId));
        return links;
    }
}

