/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.web.aspect;

import de.adorsys.psd2.xs2a.core.profile.ScaApproach;
import de.adorsys.psd2.xs2a.core.psu.PsuIdData;
import de.adorsys.psd2.xs2a.core.sca.ScaStatus;
import de.adorsys.psd2.xs2a.domain.Links;
import de.adorsys.psd2.xs2a.domain.ResponseObject;
import de.adorsys.psd2.xs2a.domain.consent.CreateConsentReq;
import de.adorsys.psd2.xs2a.domain.consent.CreateConsentResponse;
import de.adorsys.psd2.xs2a.domain.consent.UpdateConsentPsuDataReq;
import de.adorsys.psd2.xs2a.domain.consent.UpdateConsentPsuDataResponse;
import de.adorsys.psd2.xs2a.service.authorization.AuthorisationMethodService;
import de.adorsys.psd2.xs2a.service.message.MessageService;
import de.adorsys.psd2.xs2a.service.profile.AspspProfileServiceWrapper;
import de.adorsys.psd2.xs2a.web.ConsentController;
import de.adorsys.psd2.xs2a.web.aspect.AbstractLinkAspect;
import java.util.Optional;
import org.aspectj.lang.annotation.AfterReturning;
import org.aspectj.lang.annotation.Aspect;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class ConsentAspect
extends AbstractLinkAspect<ConsentController> {
    private static final Logger log = LoggerFactory.getLogger(ConsentAspect.class);
    private AuthorisationMethodService authorisationMethodService;

    public ConsentAspect(AspspProfileServiceWrapper aspspProfileService, MessageService messageService, AuthorisationMethodService authorisationMethodService) {
        super(aspspProfileService, messageService);
        this.authorisationMethodService = authorisationMethodService;
    }

    @AfterReturning(pointcut="execution(* de.adorsys.psd2.xs2a.service.ConsentService.createAccountConsentsWithResponse(..)) && args( request, psuData, explicitPreferred)", returning="result", argNames="result,request,psuData,explicitPreferred")
    public ResponseObject<CreateConsentResponse> invokeCreateAccountConsentAspect(ResponseObject<CreateConsentResponse> result, CreateConsentReq request, PsuIdData psuData, boolean explicitPreferred) {
        if (!result.hasError()) {
            CreateConsentResponse body = result.getBody();
            body.setLinks(this.buildLinksForConsentResponse(body, explicitPreferred));
            return result;
        }
        return this.enrichErrorTextMessage(result);
    }

    @AfterReturning(pointcut="execution(* de.adorsys.psd2.xs2a.service.ConsentService.updateConsentPsuData(..)) && args(updatePsuData)", returning="result", argNames="result,updatePsuData")
    public ResponseObject<UpdateConsentPsuDataResponse> invokeUpdateConsentPsuDataAspect(ResponseObject<UpdateConsentPsuDataResponse> result, UpdateConsentPsuDataReq updatePsuData) {
        if (!result.hasError()) {
            UpdateConsentPsuDataResponse body = result.getBody();
            body.setLinks(this.buildLinksForUpdateConsentResponse(body, updatePsuData));
            return result;
        }
        return this.enrichErrorTextMessage(result);
    }

    private Links buildLinksForConsentResponse(CreateConsentResponse response, boolean explicitPreferred) {
        Links links = new Links();
        if (ScaApproach.EMBEDDED == this.aspspProfileService.getScaApproach()) {
            this.buildLinkForEmbeddedScaApproach(response, links, explicitPreferred);
        } else {
            links.setScaRedirect(this.aspspProfileService.getAisRedirectUrlToAspsp() + response.getConsentId());
        }
        return links;
    }

    private void buildLinkForEmbeddedScaApproach(CreateConsentResponse response, Links links, boolean explicitPreferred) {
        if (this.authorisationMethodService.isExplicitMethod(explicitPreferred)) {
            links.setStartAuthorisation(this.buildPath("/v1/consents/{consentId}/authorisations", response.getConsentId()));
        } else {
            links.setStartAuthorisationWithPsuAuthentication(this.buildPath("/v1/consents/{consentId}/authorisations/{authorisation-id}", response.getConsentId(), response.getAuthorizationId()));
        }
    }

    private Links buildLinksForUpdateConsentResponse(UpdateConsentPsuDataResponse response, UpdateConsentPsuDataReq request) {
        return Optional.ofNullable(response.getScaStatus()).map(status -> {
            Links links = null;
            if (status == ScaStatus.PSUAUTHENTICATED) {
                links = this.buildLinksForPsuAuthenticatedConsentResponse(request);
            } else if (status == ScaStatus.SCAMETHODSELECTED) {
                links = this.buildLinksForScaMethodSelectedConsentResponse(request);
            } else if (status == ScaStatus.FINALISED) {
                links = this.buildLinksForFinalisedConsentResponse(request);
            }
            return links;
        }).orElse(null);
    }

    private Links buildLinksForPsuAuthenticatedConsentResponse(UpdateConsentPsuDataReq request) {
        Links links = new Links();
        links.setSelectAuthenticationMethod(this.buildPath("/v1/consents/{consentId}/authorisations/{authorisation-id}", request.getConsentId(), request.getAuthorizationId()));
        return links;
    }

    private Links buildLinksForScaMethodSelectedConsentResponse(UpdateConsentPsuDataReq request) {
        Links links = new Links();
        links.setAuthoriseTransaction(this.buildPath("/v1/consents/{consentId}/authorisations/{authorisation-id}", request.getConsentId(), request.getAuthorizationId()));
        return links;
    }

    private Links buildLinksForFinalisedConsentResponse(UpdateConsentPsuDataReq request) {
        Links links = new Links();
        links.setScaStatus(this.buildPath("/v1/consents/{consentId}/authorisations/{authorisation-id}", request.getConsentId(), request.getAuthorizationId()));
        return links;
    }
}

