/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.web.aspect;

import de.adorsys.psd2.xs2a.core.pis.TransactionStatus;
import de.adorsys.psd2.xs2a.core.profile.ScaApproach;
import de.adorsys.psd2.xs2a.core.psu.PsuIdData;
import de.adorsys.psd2.xs2a.domain.Links;
import de.adorsys.psd2.xs2a.domain.ResponseObject;
import de.adorsys.psd2.xs2a.domain.pis.PaymentInitiationParameters;
import de.adorsys.psd2.xs2a.domain.pis.PaymentInitiationResponse;
import de.adorsys.psd2.xs2a.service.authorization.AuthorisationMethodService;
import de.adorsys.psd2.xs2a.service.message.MessageService;
import de.adorsys.psd2.xs2a.service.profile.AspspProfileServiceWrapper;
import de.adorsys.psd2.xs2a.web.aspect.AbstractLinkAspect;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;

public abstract class AbstractPaymentLink<T>
extends AbstractLinkAspect<T> {
    private AuthorisationMethodService authorisationMethodService;

    public AbstractPaymentLink(AspspProfileServiceWrapper aspspProfileService, MessageService messageService, AuthorisationMethodService authorisationMethodService) {
        super(aspspProfileService, messageService);
        this.authorisationMethodService = authorisationMethodService;
    }

    protected ResponseObject<?> enrichLink(ResponseObject<?> result, PaymentInitiationParameters paymentRequestParameters) {
        Object body = result.getBody();
        this.doEnrichLink(paymentRequestParameters, (PaymentInitiationResponse)body);
        return result;
    }

    private void doEnrichLink(PaymentInitiationParameters paymentRequestParameters, PaymentInitiationResponse body) {
        body.setLinks(this.buildPaymentLinks(paymentRequestParameters, body));
    }

    private Links buildPaymentLinks(PaymentInitiationParameters paymentRequestParameters, PaymentInitiationResponse body) {
        if (TransactionStatus.RJCT == body.getTransactionStatus()) {
            return null;
        }
        String paymentService = paymentRequestParameters.getPaymentType().getValue();
        String paymentId = body.getPaymentId();
        Links links = new Links();
        links.setSelf(this.buildPath("/v1/{payment-service}/{payment-id}", paymentService, paymentId));
        links.setStatus(this.buildPath("/v1/{payment-service}/{payment-id}/status", paymentService, paymentId));
        if (this.aspspProfileService.getScaApproach() == ScaApproach.EMBEDDED) {
            return this.addEmbeddedRelatedLinks(links, paymentRequestParameters, body);
        }
        if (this.aspspProfileService.getScaApproach() == ScaApproach.REDIRECT) {
            return this.addRedirectRelatedLinks(links, paymentRequestParameters, body);
        }
        if (this.aspspProfileService.getScaApproach() == ScaApproach.OAUTH) {
            links.setScaOAuth("scaOAuth");
        }
        return links;
    }

    private Links addEmbeddedRelatedLinks(Links links, PaymentInitiationParameters paymentRequestParameters, PaymentInitiationResponse body) {
        String paymentService = paymentRequestParameters.getPaymentType().getValue();
        String paymentId = body.getPaymentId();
        String authorizationId = body.getAuthorizationId();
        if (this.authorisationMethodService.isExplicitMethod(paymentRequestParameters.isTppExplicitAuthorisationPreferred())) {
            links.setStartAuthorisation(this.buildPath("/v1/{payment-service}/{payment-id}/authorisations", paymentService, paymentId));
        } else {
            links.setScaStatus(this.buildPath("/v1/{payment-service}/{payment-id}/authorisations/{authorisation-id}", paymentService, paymentId, authorizationId));
            links.setStartAuthorisationWithPsuAuthentication(this.buildPath("/v1/{payment-service}/{payment-id}/authorisations/{authorisation-id}", paymentService, paymentId, authorizationId));
        }
        return links;
    }

    private Links addRedirectRelatedLinks(Links links, PaymentInitiationParameters paymentRequestParameters, PaymentInitiationResponse body) {
        String paymentService = paymentRequestParameters.getPaymentType().getValue();
        String paymentId = body.getPaymentId();
        String authorizationId = body.getAuthorizationId();
        String psuId = Optional.ofNullable(paymentRequestParameters.getPsuData()).map(PsuIdData::getPsuId).orElse(null);
        if (this.authorisationMethodService.isExplicitMethod(paymentRequestParameters.isTppExplicitAuthorisationPreferred())) {
            links.setStartAuthorisation(this.buildPath("/v1/{payment-service}/{payment-id}/authorisations", paymentService, paymentId));
        } else {
            String link = this.aspspProfileService.getPisRedirectUrlToAspsp() + body.getPisConsentId() + "/" + paymentId;
            if (StringUtils.isNotBlank((CharSequence)psuId)) {
                link = link + "/" + psuId;
            }
            links.setScaRedirect(link);
            links.setScaStatus(this.buildPath("/v1/{payment-service}/{payment-id}/authorisations/{authorisation-id}", paymentService, paymentId, authorizationId));
        }
        return links;
    }
}

