/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.web.aspect;

import de.adorsys.psd2.xs2a.domain.ResponseObject;
import de.adorsys.psd2.xs2a.domain.TppMessageInformation;
import de.adorsys.psd2.xs2a.exception.MessageError;
import de.adorsys.psd2.xs2a.service.message.MessageService;
import de.adorsys.psd2.xs2a.service.profile.AspspProfileServiceWrapper;
import java.beans.ConstructorProperties;
import java.lang.reflect.ParameterizedType;
import java.util.Collections;
import java.util.Optional;
import org.springframework.hateoas.mvc.ControllerLinkBuilder;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.web.util.UriComponentsBuilder;

@Component
public abstract class AbstractLinkAspect<T> {
    protected final AspspProfileServiceWrapper aspspProfileService;
    private final MessageService messageService;

    protected <B> boolean hasError(ResponseEntity<B> target) {
        Optional<Object> body = Optional.ofNullable(target.getBody());
        return body.isPresent() && body.get().getClass().isAssignableFrom(MessageError.class);
    }

    <R> ResponseObject<R> enrichErrorTextMessage(ResponseObject<R> response) {
        MessageError error = response.getError();
        TppMessageInformation tppMessage = error.getTppMessage();
        tppMessage.setText(this.messageService.getMessage(tppMessage.getMessageErrorCode().name()));
        error.setTppMessages(Collections.singleton(tppMessage));
        return ResponseObject.builder().fail(error).build();
    }

    String buildPath(String path, Object ... params) {
        return UriComponentsBuilder.fromHttpUrl((String)ControllerLinkBuilder.linkTo(this.getControllerClass()).toString()).path(path).buildAndExpand(params).toUriString();
    }

    private Class<T> getControllerClass() {
        try {
            String className = ((ParameterizedType)this.getClass().getGenericSuperclass()).getActualTypeArguments()[0].getTypeName();
            return Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException("Class isn't parametrized with generic type! Use <>");
        }
    }

    @ConstructorProperties(value={"aspspProfileService", "messageService"})
    public AbstractLinkAspect(AspspProfileServiceWrapper aspspProfileService, MessageService messageService) {
        this.aspspProfileService = aspspProfileService;
        this.messageService = messageService;
    }
}

