/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.web.advice;

import de.adorsys.psd2.model.PaymentInitationRequestResponse201;
import de.adorsys.psd2.xs2a.service.profile.AspspProfileServiceWrapper;
import de.adorsys.psd2.xs2a.web.PaymentController;
import de.adorsys.psd2.xs2a.web.advice.CommonHeaderModifierAdvice;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.core.MethodParameter;
import org.springframework.http.MediaType;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.server.ServerHttpRequest;
import org.springframework.http.server.ServerHttpResponse;
import org.springframework.web.bind.annotation.ControllerAdvice;

@ControllerAdvice(assignableTypes={PaymentController.class})
public class PaymentHeaderModifierAdvice
extends CommonHeaderModifierAdvice {
    public PaymentHeaderModifierAdvice(AspspProfileServiceWrapper aspspProfileServiceWrapper) {
        super(aspspProfileServiceWrapper);
    }

    @Override
    public boolean supports(MethodParameter returnType, Class<? extends HttpMessageConverter<?>> converterType) {
        return true;
    }

    @Override
    public Object beforeBodyWrite(Object body, MethodParameter returnType, MediaType selectedContentType, Class<? extends HttpMessageConverter<?>> selectedConverterType, ServerHttpRequest request, ServerHttpResponse response) {
        String methodName = returnType.getMethod().getName();
        if ("_startPaymentAuthorisation".equals(methodName) || "_startPaymentInitiationCancellationAuthorisation".equals(methodName) || "_updatePaymentCancellationPsuData".equals(methodName) || "_updatePaymentPsuData".equals(methodName)) {
            response.getHeaders().add("Aspsp-Sca-Approach", this.getScaApproach().name());
        } else if ("_initiatePayment".equals(methodName)) {
            response.getHeaders().add("Aspsp-Sca-Approach", this.getScaApproach().name());
            response.getHeaders().add("Location", this.getLocationHeaderForInitiatePayment(body));
        }
        return body;
    }

    private String getLocationHeaderForInitiatePayment(Object body) {
        String location = null;
        if (body instanceof List) {
            List responseList = (List)body;
            if (CollectionUtils.isNotEmpty((Collection)responseList)) {
                location = this.getSelfLink(responseList.get(0));
            }
        } else {
            location = this.getSelfLink(body);
        }
        return location;
    }

    private String getSelfLink(Object response) {
        String selfLink = null;
        if (response instanceof PaymentInitationRequestResponse201) {
            PaymentInitationRequestResponse201 paymentResponse = (PaymentInitationRequestResponse201)response;
            selfLink = Optional.ofNullable(paymentResponse.getLinks()).map(links -> links.get("self").toString()).orElse(null);
        }
        return selfLink;
    }
}

