/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.web.advice;

import de.adorsys.psd2.model.TppMessages;
import de.adorsys.psd2.xs2a.core.profile.ScaApproach;
import de.adorsys.psd2.xs2a.service.profile.AspspProfileServiceWrapper;
import java.beans.ConstructorProperties;
import java.util.Optional;
import org.springframework.core.MethodParameter;
import org.springframework.http.MediaType;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.server.ServerHttpRequest;
import org.springframework.http.server.ServerHttpResponse;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.servlet.mvc.method.annotation.ResponseBodyAdvice;

@ControllerAdvice
public class CommonHeaderModifierAdvice
implements ResponseBodyAdvice<Object> {
    private final AspspProfileServiceWrapper aspspProfileServiceWrapper;

    public boolean supports(MethodParameter returnType, Class<? extends HttpMessageConverter<?>> converterType) {
        return true;
    }

    public Object beforeBodyWrite(Object body, MethodParameter returnType, MediaType selectedContentType, Class<? extends HttpMessageConverter<?>> selectedConverterType, ServerHttpRequest request, ServerHttpResponse response) {
        response.getHeaders().add("X-Request-Id", request.getHeaders().getFirst("X-Request-Id"));
        return body;
    }

    protected ScaApproach getScaApproach() {
        ScaApproach scaApproach = this.aspspProfileServiceWrapper.getScaApproach();
        if (scaApproach == ScaApproach.OAUTH) {
            scaApproach = ScaApproach.REDIRECT;
        }
        return scaApproach;
    }

    protected boolean hasError(Object body) {
        return Optional.ofNullable(body).isPresent() && body.getClass().isAssignableFrom(TppMessages.class);
    }

    @ConstructorProperties(value={"aspspProfileServiceWrapper"})
    public CommonHeaderModifierAdvice(AspspProfileServiceWrapper aspspProfileServiceWrapper) {
        this.aspspProfileServiceWrapper = aspspProfileServiceWrapper;
    }
}

