/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.web;

import de.adorsys.psd2.api.PaymentApi;
import de.adorsys.psd2.model.PaymentInitiationCancelResponse200202;
import de.adorsys.psd2.xs2a.core.profile.PaymentProduct;
import de.adorsys.psd2.xs2a.core.profile.PaymentType;
import de.adorsys.psd2.xs2a.core.psu.PsuIdData;
import de.adorsys.psd2.xs2a.domain.MessageErrorCode;
import de.adorsys.psd2.xs2a.domain.ResponseObject;
import de.adorsys.psd2.xs2a.domain.consent.pis.Xs2aUpdatePisConsentPsuDataResponse;
import de.adorsys.psd2.xs2a.domain.pis.CancelPaymentResponse;
import de.adorsys.psd2.xs2a.domain.pis.PaymentInitiationParameters;
import de.adorsys.psd2.xs2a.exception.MessageError;
import de.adorsys.psd2.xs2a.service.ConsentService;
import de.adorsys.psd2.xs2a.service.PaymentService;
import de.adorsys.psd2.xs2a.service.mapper.ResponseMapper;
import de.adorsys.psd2.xs2a.web.mapper.ConsentModelMapper;
import de.adorsys.psd2.xs2a.web.mapper.PaymentModelMapperPsd2;
import de.adorsys.psd2.xs2a.web.mapper.PaymentModelMapperXs2a;
import io.swagger.annotations.Api;
import java.beans.ConstructorProperties;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.lang3.BooleanUtils;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(value="v1", description="Provides access to the payment initiation", tags={"Payment Initiation Service (PIS)"})
public class PaymentController
implements PaymentApi {
    private final PaymentService xs2aPaymentService;
    private final ResponseMapper responseMapper;
    private final PaymentModelMapperPsd2 paymentModelMapperPsd2;
    private final PaymentModelMapperXs2a paymentModelMapperXs2a;
    private final ConsentService consentService;
    private final ConsentModelMapper consentModelMapper;

    public ResponseEntity getPaymentInitiationStatus(String paymentService, String paymentId, UUID xRequestID, String digest, String signature, byte[] tpPSignatureCertificate, String psUIPAddress, Object psUIPPort, String psUAccept, String psUAcceptCharset, String psUAcceptEncoding, String psUAcceptLanguage, String psUUserAgent, String psUHttpMethod, UUID psUDeviceID, String psUGeoLocation) {
        ResponseObject response = PaymentType.getByValue((String)paymentService).map(pt -> this.xs2aPaymentService.getPaymentStatusById((PaymentType)pt, paymentId)).orElseGet(ResponseObject.builder().fail(new MessageError(MessageErrorCode.FORMAT_ERROR))::build);
        return this.responseMapper.ok(response, PaymentModelMapperPsd2::mapToStatusResponse12);
    }

    public ResponseEntity getPaymentInformation(String paymentService, String paymentId, UUID xRequestID, String digest, String signature, byte[] tpPSignatureCertificate, String psUIPAddress, Object psUIPPort, String psUAccept, String psUAcceptCharset, String psUAcceptEncoding, String psUAcceptLanguage, String psUUserAgent, String psUHttpMethod, UUID psUDeviceID, String psUGeoLocation) {
        ResponseObject response = PaymentType.getByValue((String)paymentService).map(pt -> this.xs2aPaymentService.getPaymentById((PaymentType)pt, paymentId)).orElseGet(ResponseObject.builder().fail(new MessageError(MessageErrorCode.FORMAT_ERROR))::build);
        return response.hasError() ? this.responseMapper.ok(response) : this.responseMapper.ok(ResponseObject.builder().body(this.paymentModelMapperPsd2.mapToGetPaymentResponse12(response.getBody(), (PaymentType)PaymentType.getByValue((String)paymentService).get(), PaymentProduct.SEPA)).build());
    }

    public ResponseEntity initiatePayment(Object body, String paymentService, String paymentProduct, UUID xRequestID, String psUIPAddress, String digest, String signature, byte[] tpPSignatureCertificate, String PSU_ID, String psUIDType, String psUCorporateID, String psUCorporateIDType, String consentID, Boolean tpPRedirectPreferred, String tpPRedirectURI, String tpPNokRedirectURI, Boolean tpPExplicitAuthorisationPreferred, Object psUIPPort, String psUAccept, String psUAcceptCharset, String psUAcceptEncoding, String psUAcceptLanguage, String psUUserAgent, String psUHttpMethod, UUID psUDeviceID, String psUGeoLocation) {
        PsuIdData psuData = new PsuIdData(PSU_ID, psUIDType, psUCorporateID, psUCorporateIDType);
        PaymentInitiationParameters paymentInitiationParameters = this.paymentModelMapperPsd2.mapToPaymentRequestParameters(paymentProduct, paymentService, tpPSignatureCertificate, tpPRedirectURI, tpPNokRedirectURI, BooleanUtils.isTrue((Boolean)tpPExplicitAuthorisationPreferred), psuData);
        ResponseObject serviceResponse = this.xs2aPaymentService.createPayment(this.paymentModelMapperXs2a.mapToXs2aPayment(body, paymentInitiationParameters), paymentInitiationParameters);
        return serviceResponse.hasError() ? this.responseMapper.created(serviceResponse) : this.responseMapper.created(ResponseObject.builder().body(this.paymentModelMapperPsd2.mapToPaymentInitiationResponse12(serviceResponse.getBody())).build());
    }

    public ResponseEntity cancelPayment(String paymentService, String paymentId, UUID xRequestID, String digest, String signature, byte[] tpPSignatureCertificate, String psUIPAddress, Object psUIPPort, String psUAccept, String psUAcceptCharset, String psUAcceptEncoding, String psUAcceptLanguage, String psUUserAgent, String psUHttpMethod, UUID psUDeviceID, String psUGeoLocation) {
        ResponseObject serviceResponse = PaymentType.getByValue((String)paymentService).map(type -> this.xs2aPaymentService.cancelPayment((PaymentType)type, paymentId)).orElseGet(ResponseObject.builder().fail(new MessageError(MessageErrorCode.FORMAT_ERROR))::build);
        if (serviceResponse.hasError()) {
            return this.responseMapper.ok(serviceResponse);
        }
        CancelPaymentResponse cancelPayment = (CancelPaymentResponse)serviceResponse.getBody();
        PaymentInitiationCancelResponse200202 response = this.paymentModelMapperPsd2.mapToPaymentInitiationCancelResponse(cancelPayment);
        return cancelPayment.isStartAuthorisationRequired() ? this.responseMapper.accepted(ResponseObject.builder().body(response).build()) : this.responseMapper.ok(ResponseObject.builder().body(response).build());
    }

    public ResponseEntity getPaymentCancellationScaStatus(String paymentService, String paymentId, String cancellationId, UUID xRequestID, String digest, String signature, byte[] tpPSignatureCertificate, String psUIPAddress, Object psUIPPort, String psUAccept, String psUAcceptCharset, String psUAcceptEncoding, String psUAcceptLanguage, String psUUserAgent, String psUHttpMethod, UUID psUDeviceID, String psUGeoLocation) {
        return null;
    }

    public ResponseEntity getPaymentInitiationAuthorisation(String paymentService, String paymentId, UUID xRequestID, String digest, String signature, byte[] tpPSignatureCertificate, String psUIPAddress, Object psUIPPort, String psUAccept, String psUAcceptCharset, String psUAcceptEncoding, String psUAcceptLanguage, String psUUserAgent, String psUHttpMethod, UUID psUDeviceID, String psUGeoLocation) {
        return null;
    }

    public ResponseEntity getPaymentInitiationCancellationAuthorisationInformation(String paymentService, String paymentId, UUID xRequestID, String digest, String signature, byte[] tpPSignatureCertificate, String psUIPAddress, Object psUIPPort, String psUAccept, String psUAcceptCharset, String psUAcceptEncoding, String psUAcceptLanguage, String psUUserAgent, String psUHttpMethod, UUID psUDeviceID, String psUGeoLocation) {
        return this.responseMapper.ok(this.consentService.getPaymentInitiationCancellationAuthorisationInformation(paymentId));
    }

    public ResponseEntity getPaymentInitiationScaStatus(String paymentService, String paymentId, String authorisationId, UUID xRequestID, String digest, String signature, byte[] tpPSignatureCertificate, String psUIPAddress, Object psUIPPort, String psUAccept, String psUAcceptCharset, String psUAcceptEncoding, String psUAcceptLanguage, String psUUserAgent, String psUHttpMethod, UUID psUDeviceID, String psUGeoLocation) {
        return null;
    }

    public ResponseEntity startPaymentAuthorisation(String paymentService, String paymentId, UUID xRequestID, String PSU_ID, String psUIDType, String psUCorporateID, String psUCorporateIDType, String digest, String signature, byte[] tpPSignatureCertificate, String psUIPAddress, Object psUIPPort, String psUAccept, String psUAcceptCharset, String psUAcceptEncoding, String psUAcceptLanguage, String psUUserAgent, String psUHttpMethod, UUID psUDeviceID, String psUGeoLocation) {
        PsuIdData psuData = new PsuIdData(PSU_ID, psUIDType, psUCorporateID, psUCorporateIDType);
        return this.responseMapper.created(this.consentService.createPisConsentAuthorization(paymentId, (PaymentType)PaymentType.getByValue((String)paymentService).get(), psuData), this.consentModelMapper::mapToStartScaProcessResponse);
    }

    public ResponseEntity startPaymentInitiationCancellationAuthorisation(String paymentService, String paymentId, UUID xRequestID, String digest, String signature, byte[] tpPSignatureCertificate, String PSU_ID, String psUIDType, String psUCorporateID, String psUCorporateIDType, String psUIPAddress, Object psUIPPort, String psUAccept, String psUAcceptCharset, String psUAcceptEncoding, String psUAcceptLanguage, String psUUserAgent, String psUHttpMethod, UUID psUDeviceID, String psUGeoLocation) {
        return this.responseMapper.created(this.consentService.createPisConsentCancellationAuthorization(paymentId, (PaymentType)PaymentType.getByValue((String)paymentService).get()), this.consentModelMapper::mapToStartScaProcessResponse);
    }

    public ResponseEntity updatePaymentCancellationPsuData(String paymentService, String paymentId, String cancellationId, UUID xRequestID, Object body, String digest, String signature, byte[] tpPSignatureCertificate, String PSU_ID, String psUIDType, String psUCorporateID, String psUCorporateIDType, String psUIPAddress, Object psUIPPort, String psUAccept, String psUAcceptCharset, String psUAcceptEncoding, String psUAcceptLanguage, String psUUserAgent, String psUHttpMethod, UUID psUDeviceID, String psUGeoLocation) {
        PsuIdData psuData = new PsuIdData(PSU_ID, psUIDType, psUCorporateID, psUCorporateIDType);
        ResponseObject<Xs2aUpdatePisConsentPsuDataResponse> response = this.consentService.updatePisConsentCancellationPsuData(this.consentModelMapper.mapToPisUpdatePsuData(psuData, paymentId, cancellationId, paymentService, (Map)body));
        return this.responseMapper.ok(response, this.consentModelMapper::mapToUpdatePsuAuthenticationResponse);
    }

    public ResponseEntity updatePaymentPsuData(String paymentService, String paymentId, String authorisationId, UUID xRequestID, Object body, String digest, String signature, byte[] tpPSignatureCertificate, String PSU_ID, String psUIDType, String psUCorporateID, String psUCorporateIDType, String psUIPAddress, Object psUIPPort, String psUAccept, String psUAcceptCharset, String psUAcceptEncoding, String psUAcceptLanguage, String psUUserAgent, String psUHttpMethod, UUID psUDeviceID, String psUGeoLocation) {
        PsuIdData psuData = new PsuIdData(PSU_ID, psUIDType, psUCorporateID, psUCorporateIDType);
        return this.responseMapper.ok(this.consentService.updatePisConsentPsuData(this.consentModelMapper.mapToPisUpdatePsuData(psuData, paymentId, authorisationId, paymentService, (Map)body)), this.consentModelMapper::mapToUpdatePsuAuthenticationResponse);
    }

    @ConstructorProperties(value={"xs2aPaymentService", "responseMapper", "paymentModelMapperPsd2", "paymentModelMapperXs2a", "consentService", "consentModelMapper"})
    public PaymentController(PaymentService xs2aPaymentService, ResponseMapper responseMapper, PaymentModelMapperPsd2 paymentModelMapperPsd2, PaymentModelMapperXs2a paymentModelMapperXs2a, ConsentService consentService, ConsentModelMapper consentModelMapper) {
        this.xs2aPaymentService = xs2aPaymentService;
        this.responseMapper = responseMapper;
        this.paymentModelMapperPsd2 = paymentModelMapperPsd2;
        this.paymentModelMapperXs2a = paymentModelMapperXs2a;
        this.consentService = consentService;
        this.consentModelMapper = consentModelMapper;
    }
}

