/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.web;

import de.adorsys.psd2.api.ConsentApi;
import de.adorsys.psd2.model.Consents;
import de.adorsys.psd2.xs2a.core.psu.PsuIdData;
import de.adorsys.psd2.xs2a.domain.ResponseObject;
import de.adorsys.psd2.xs2a.domain.account.Xs2aAccountReference;
import de.adorsys.psd2.xs2a.domain.consent.CreateConsentAuthorizationResponse;
import de.adorsys.psd2.xs2a.domain.consent.CreateConsentReq;
import de.adorsys.psd2.xs2a.domain.consent.UpdateConsentPsuDataReq;
import de.adorsys.psd2.xs2a.service.AccountReferenceValidationService;
import de.adorsys.psd2.xs2a.service.ConsentService;
import de.adorsys.psd2.xs2a.service.mapper.ResponseMapper;
import de.adorsys.psd2.xs2a.web.mapper.AuthorisationMapper;
import de.adorsys.psd2.xs2a.web.mapper.ConsentModelMapper;
import io.swagger.annotations.Api;
import java.beans.ConstructorProperties;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.apache.commons.lang3.BooleanUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(value="v1", description="Provides access to the account information", tags={"Account Information Service (AIS)"})
public class ConsentController
implements ConsentApi {
    private static final Logger log = LoggerFactory.getLogger(ConsentController.class);
    private final ConsentService consentService;
    private final ResponseMapper responseMapper;
    private final AccountReferenceValidationService referenceValidationService;
    private final ConsentModelMapper consentModelMapper;
    private final AuthorisationMapper authorisationMapper;

    public ResponseEntity createConsent(UUID xRequestID, Consents body, String digest, String signature, byte[] tpPSignatureCertificate, String PSU_ID, String psUIDType, String psUCorporateID, String psUCorporateIDType, Boolean tpPRedirectPreferred, String tpPRedirectURI, String tpPNokRedirectURI, Boolean tpPExplicitAuthorisationPreferred, String psUIPAddress, Object psUIPPort, String psUAccept, String psUAcceptCharset, String psUAcceptEncoding, String psUAcceptLanguage, String psUUserAgent, String psUHttpMethod, UUID psUDeviceID, String psUGeoLocation) {
        ResponseObject<Object> createConsentResponse;
        ResponseObject accountReferenceValidationResponse;
        CreateConsentReq createConsent = this.consentModelMapper.mapToCreateConsentReq(body);
        Set<Xs2aAccountReference> references = createConsent.getAccountReferences();
        ResponseObject responseObject = accountReferenceValidationResponse = references.isEmpty() ? ResponseObject.builder().build() : this.referenceValidationService.validateAccountReferences(createConsent.getAccountReferences());
        if (accountReferenceValidationResponse.hasError()) {
            createConsentResponse = ResponseObject.builder().fail(accountReferenceValidationResponse.getError()).build();
        } else {
            PsuIdData psuData = new PsuIdData(PSU_ID, psUIDType, psUCorporateID, psUCorporateIDType);
            createConsentResponse = this.consentService.createAccountConsentsWithResponse(createConsent, psuData, BooleanUtils.isTrue((Boolean)tpPExplicitAuthorisationPreferred));
        }
        return this.responseMapper.created(createConsentResponse, this.consentModelMapper::mapToConsentsResponse201);
    }

    public ResponseEntity getConsentStatus(String consentId, UUID xRequestID, String digest, String signature, byte[] tpPSignatureCertificate, String psUIPAddress, Object psUIPPort, String psUAccept, String psUAcceptCharset, String psUAcceptEncoding, String psUAcceptLanguage, String psUUserAgent, String psUHttpMethod, UUID psUDeviceID, String psUGeoLocation) {
        return this.responseMapper.ok(this.consentService.getAccountConsentsStatusById(consentId), this.consentModelMapper::mapToConsentStatusResponse200);
    }

    public ResponseEntity startConsentAuthorisation(String consentId, UUID xRequestID, String digest, String signature, byte[] tpPSignatureCertificate, String PSU_ID, String psUIDType, String psUCorporateID, String psUCorporateIDType, String psUIPAddress, Object psUIPPort, String psUAccept, String psUAcceptCharset, String psUAcceptEncoding, String psUAcceptLanguage, String psUUserAgent, String psUHttpMethod, UUID psUDeviceID, String psUGeoLocation) {
        PsuIdData psuData = new PsuIdData(PSU_ID, psUIDType, psUCorporateID, psUCorporateIDType);
        ResponseObject<CreateConsentAuthorizationResponse> consentAuthorizationWithResponse = this.consentService.createConsentAuthorizationWithResponse(psuData, consentId);
        return this.responseMapper.created(consentAuthorizationWithResponse, this.authorisationMapper::mapToStartScaProcessResponse);
    }

    public ResponseEntity updateConsentsPsuData(String consentId, String authorisationId, UUID xRequestID, Object body, String digest, String signature, byte[] tpPSignatureCertificate, String PSU_ID, String psUIDType, String psUCorporateID, String psUCorporateIDType, String psUIPAddress, Object psUIPPort, String psUAccept, String psUAcceptCharset, String psUAcceptEncoding, String psUAcceptLanguage, String psUUserAgent, String psUHttpMethod, UUID psUDeviceID, String psUGeoLocation) {
        PsuIdData psuData = new PsuIdData(PSU_ID, psUIDType, psUCorporateID, psUCorporateIDType);
        UpdateConsentPsuDataReq updatePsuDataRequest = this.consentModelMapper.mapToUpdatePsuData(psuData, consentId, authorisationId, (Map)body);
        return this.responseMapper.ok(this.consentService.updateConsentPsuData(updatePsuDataRequest), this.consentModelMapper::mapToUpdatePsuAuthenticationResponse);
    }

    public ResponseEntity getConsentScaStatus(String consentId, String authorisationId, UUID xRequestID, String digest, String signature, byte[] tpPSignatureCertificate, String psUIPAddress, Object psUIPPort, String psUAccept, String psUAcceptCharset, String psUAcceptEncoding, String psUAcceptLanguage, String psUUserAgent, String psUHttpMethod, UUID psUDeviceID, String psUGeoLocation) {
        return null;
    }

    public ResponseEntity getConsentAuthorisations(String consentId, UUID xRequestID, String digest, String signature, byte[] tpPSignatureCertificate, String psUIPAddress, Object psUIPPort, String psUAccept, String psUAcceptCharset, String psUAcceptEncoding, String psUAcceptLanguage, String psUUserAgent, String psUHttpMethod, UUID psUDeviceID, String psUGeoLocation) {
        return null;
    }

    public ResponseEntity getConsentInformation(String consentId, UUID xRequestID, String digest, String signature, byte[] tpPSignatureCertificate, String psUIPAddress, Object psUIPPort, String psUAccept, String psUAcceptCharset, String psUAcceptEncoding, String psUAcceptLanguage, String psUUserAgent, String psUHttpMethod, UUID psUDeviceID, String psUGeoLocation) {
        return this.responseMapper.ok(this.consentService.getAccountConsentById(consentId), this.consentModelMapper::mapToConsentInformationResponse200Json);
    }

    public ResponseEntity deleteConsent(String consentId, UUID xRequestID, String digest, String signature, byte[] tpPSignatureCertificate, String psUIPAddress, Object psUIPPort, String psUAccept, String psUAcceptCharset, String psUAcceptEncoding, String psUAcceptLanguage, String psUUserAgent, String psUHttpMethod, UUID psUDeviceID, String psUGeoLocation) {
        ResponseObject<Void> response = this.consentService.deleteAccountConsentsById(consentId);
        return this.responseMapper.delete(response);
    }

    @ConstructorProperties(value={"consentService", "responseMapper", "referenceValidationService", "consentModelMapper", "authorisationMapper"})
    public ConsentController(ConsentService consentService, ResponseMapper responseMapper, AccountReferenceValidationService referenceValidationService, ConsentModelMapper consentModelMapper, AuthorisationMapper authorisationMapper) {
        this.consentService = consentService;
        this.responseMapper = responseMapper;
        this.referenceValidationService = referenceValidationService;
        this.consentModelMapper = consentModelMapper;
        this.authorisationMapper = authorisationMapper;
    }
}

