/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.service.validator;

import de.adorsys.psd2.xs2a.core.profile.PaymentProduct;
import de.adorsys.psd2.xs2a.core.profile.PaymentType;
import de.adorsys.psd2.xs2a.domain.MessageErrorCode;
import de.adorsys.psd2.xs2a.service.profile.AspspProfileServiceWrapper;
import de.adorsys.psd2.xs2a.service.validator.header.HeadersFactory;
import de.adorsys.psd2.xs2a.service.validator.header.RequestHeader;
import de.adorsys.psd2.xs2a.service.validator.header.impl.ErrorMessageHeaderImpl;
import de.adorsys.psd2.xs2a.service.validator.header.impl.PaymentInitiationRequestHeader;
import de.adorsys.psd2.xs2a.service.validator.parameter.ParametersFactory;
import de.adorsys.psd2.xs2a.service.validator.parameter.RequestParameter;
import de.adorsys.psd2.xs2a.service.validator.parameter.impl.ErrorMessageParameterImpl;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.validation.ConstraintViolation;
import javax.validation.Validator;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.cors.CorsConfigurationSource;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.HandlerMapping;

@Service
public class RequestValidatorService {
    private static final Logger log = Logger.getLogger(RequestValidatorService.class);
    @Autowired
    private ParametersFactory parametersFactory;
    @Autowired
    private Validator validator;
    @Autowired
    private AspspProfileServiceWrapper aspspProfileService;
    private static final String PAYMENT_PRODUCT_PATH_VAR = "payment-product";
    private static final String PAYMENT_SERVICE_PATH_VAR = "payment-service";

    public Map<String, String> getRequestViolationMap(HttpServletRequest request, Object handler) {
        HashMap<String, String> violationMap = new HashMap<String, String>();
        if (handler instanceof CorsConfigurationSource) {
            return violationMap;
        }
        if (handler instanceof HandlerMethod) {
            HandlerMethod handlerMethod = (HandlerMethod)handler;
            violationMap.putAll(this.getRequestHeaderViolationMap(request, handlerMethod));
            violationMap.putAll(this.getRequestParametersViolationMap(request, handlerMethod));
            violationMap.putAll(this.getRequestPathVariablesViolationMap(request));
        }
        return violationMap;
    }

    public Map<String, String> getRequestViolationMapInitiatePayment(Map<String, String> requestHeadersMap) {
        RequestHeader headerImpl = HeadersFactory.getHeadersImplByRequestHeaderClass(requestHeadersMap, PaymentInitiationRequestHeader.class);
        if (headerImpl instanceof ErrorMessageHeaderImpl) {
            return Collections.singletonMap("Wrong header arguments: ", ((ErrorMessageHeaderImpl)headerImpl).getErrorMessage());
        }
        return this.getViolationMessagesMap(this.validator.validate((Object)headerImpl, new Class[0]));
    }

    public Map<String, String> getRequestViolationMapInitiatePayment(HttpServletRequest request) {
        Map<String, String> requestHeadersMap = this.getRequestHeadersMap(request);
        return this.getRequestViolationMapInitiatePayment(requestHeadersMap);
    }

    private Map<String, String> getRequestParametersViolationMap(HttpServletRequest request, HandlerMethod handler) {
        Map<String, String> requestParameterMap = this.getRequestParametersMap(request);
        RequestParameter parameterImpl = this.parametersFactory.getParameterImpl(requestParameterMap, handler.getBeanType());
        if (parameterImpl instanceof ErrorMessageParameterImpl) {
            return Collections.singletonMap("Wrong parameters : ", ((ErrorMessageParameterImpl)parameterImpl).getErrorMessage());
        }
        return this.getViolationMessagesMap(this.validator.validate((Object)parameterImpl, new Class[0]));
    }

    private Map<String, String> getRequestPathVariablesViolationMap(HttpServletRequest request) {
        HashMap<String, String> requestPathViolationMap = new HashMap<String, String>();
        requestPathViolationMap.putAll(this.checkPaymentProductByRequest(request));
        requestPathViolationMap.putAll(this.getPaymentTypeViolationMap(request));
        return requestPathViolationMap;
    }

    private Map<String, String> getPaymentTypeViolationMap(HttpServletRequest request) {
        Map<String, String> pathVariableMap = this.getPathVariableMap(request);
        return Optional.ofNullable(pathVariableMap).map(m -> (String)m.get(PAYMENT_SERVICE_PATH_VAR)).flatMap(PaymentType::getByValue).map(this::getViolationMapForPaymentType).orElseGet(Collections::emptyMap);
    }

    private Map<String, String> getRequestHeaderViolationMap(HttpServletRequest request, HandlerMethod handler) {
        Map<String, String> requestHeadersMap = this.getRequestHeadersMap(request);
        RequestHeader headerImpl = HeadersFactory.getHeadersImpl(requestHeadersMap, handler.getBeanType());
        if (headerImpl instanceof ErrorMessageHeaderImpl) {
            return Collections.singletonMap("Wrong header arguments: ", ((ErrorMessageHeaderImpl)headerImpl).getErrorMessage());
        }
        return this.getViolationMessagesMap(this.validator.validate((Object)headerImpl, new Class[0]));
    }

    private Map<String, String> getRequestHeadersMap(HttpServletRequest request) {
        HashMap<String, String> requestHeaderMap = new HashMap<String, String>();
        if (request == null) {
            return requestHeaderMap;
        }
        Enumeration headerNames = request.getHeaderNames();
        while (headerNames.hasMoreElements()) {
            String key = (String)headerNames.nextElement();
            String value = request.getHeader(key);
            requestHeaderMap.put(key, value);
        }
        requestHeaderMap.putIfAbsent("date", "Sun, 11 Aug 2019 15:02:37 GMT");
        return requestHeaderMap;
    }

    private Map<String, String> getRequestParametersMap(HttpServletRequest request) {
        return request.getParameterMap().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> String.join((CharSequence)",", (CharSequence[])e.getValue())));
    }

    private Map<String, String> checkPaymentProductByRequest(HttpServletRequest request) {
        Map pathVariableMap = (Map)request.getAttribute(HandlerMapping.URI_TEMPLATE_VARIABLES_ATTRIBUTE);
        return Optional.ofNullable(pathVariableMap).map(mp -> (String)mp.get(PAYMENT_PRODUCT_PATH_VAR)).map(this::checkPaymentProductSupportAndGetViolationMap).orElseGet(Collections::emptyMap);
    }

    private Map<String, String> checkPaymentProductSupportAndGetViolationMap(String paymentProduct) {
        return Optional.ofNullable(paymentProduct).flatMap(PaymentProduct::getByValue).map(this::getViolationMapForPaymentProduct).orElseGet(() -> Collections.singletonMap(MessageErrorCode.PRODUCT_UNKNOWN.getName(), "Wrong payment product: " + paymentProduct));
    }

    private Map<String, String> getViolationMapForPaymentProduct(PaymentProduct paymentProduct) {
        return this.isPaymentProductAvailable(paymentProduct) ? Collections.emptyMap() : Collections.singletonMap(MessageErrorCode.PRODUCT_UNKNOWN.getName(), "Wrong payment product: " + paymentProduct.getValue());
    }

    private Map<String, String> getViolationMapForPaymentType(PaymentType paymentType) {
        PaymentType consentPaymentType = PaymentType.valueOf((String)paymentType.name());
        return this.isPaymentTypeAvailable(consentPaymentType) ? Collections.emptyMap() : Collections.singletonMap(MessageErrorCode.PARAMETER_NOT_SUPPORTED.getName(), "Wrong payment type: " + paymentType.getValue());
    }

    private boolean isPaymentProductAvailable(PaymentProduct paymentProduct) {
        List<PaymentProduct> paymentProducts = this.aspspProfileService.getAvailablePaymentProducts();
        return paymentProducts.contains(paymentProduct);
    }

    private boolean isPaymentTypeAvailable(PaymentType paymentType) {
        List<PaymentType> paymentTypes = this.aspspProfileService.getAvailablePaymentTypes();
        return paymentTypes.contains(paymentType);
    }

    private <T> Map<String, String> getViolationMessagesMap(Set<ConstraintViolation<T>> collection) {
        return collection.stream().collect(Collectors.toMap(violation -> violation.getPropertyPath().toString(), violation -> "'" + violation.getPropertyPath().toString() + "' " + violation.getMessage()));
    }

    private Map<String, String> getPathVariableMap(HttpServletRequest request) {
        return (Map)request.getAttribute(HandlerMapping.URI_TEMPLATE_VARIABLES_ATTRIBUTE);
    }
}

