/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.service.validator;

import de.adorsys.psd2.consent.api.piis.CmsPiisValidationInfo;
import de.adorsys.psd2.consent.api.piis.PiisConsentTppAccessType;
import de.adorsys.psd2.xs2a.core.consent.ConsentStatus;
import de.adorsys.psd2.xs2a.domain.MessageErrorCode;
import de.adorsys.psd2.xs2a.domain.ResponseObject;
import de.adorsys.psd2.xs2a.exception.MessageError;
import de.adorsys.psd2.xs2a.service.TppService;
import java.beans.ConstructorProperties;
import java.time.LocalDate;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.stereotype.Service;

@Service
public class PiisConsentValidationService {
    private final TppService tppService;

    public ResponseObject<String> validatePiisConsentData(List<CmsPiisValidationInfo> cmsPiisValidationInfoList) {
        if (CollectionUtils.isEmpty(cmsPiisValidationInfoList)) {
            return ResponseObject.builder().fail(new MessageError(MessageErrorCode.NO_PIIS_ACTIVATION)).build();
        }
        String tppId = this.tppService.getTppId();
        List filteredResponse = cmsPiisValidationInfoList.stream().filter(e -> EnumSet.of(ConsentStatus.VALID, ConsentStatus.RECEIVED).contains(e.getConsentStatus())).filter(e -> Optional.ofNullable(e.getExpireDate()).map(d -> d.compareTo(LocalDate.now()) >= 0).orElse(true)).filter(e -> e.getPiisConsentTppAccessType() == PiisConsentTppAccessType.ALL_TPP || tppId.equals(e.getTppInfoId())).collect(Collectors.toList());
        if (filteredResponse.isEmpty()) {
            return ResponseObject.builder().fail(new MessageError(MessageErrorCode.CONSENT_INVALID)).build();
        }
        List validResponse = filteredResponse.stream().filter(e -> e.getFrequencyPerDay() > 0).collect(Collectors.toList());
        if (validResponse.isEmpty()) {
            return ResponseObject.builder().fail(new MessageError(MessageErrorCode.ACCESS_EXCEEDED)).build();
        }
        String consentId = ((CmsPiisValidationInfo)validResponse.get(0)).getConsentId();
        return ResponseObject.builder().body(consentId).build();
    }

    @ConstructorProperties(value={"tppService"})
    public PiisConsentValidationService(TppService tppService) {
        this.tppService = tppService;
    }
}

