/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.service.profile;

import de.adorsys.psd2.aspsp.profile.domain.AspspSettings;
import de.adorsys.psd2.aspsp.profile.service.AspspProfileService;
import de.adorsys.psd2.xs2a.core.profile.PaymentProduct;
import de.adorsys.psd2.xs2a.core.profile.PaymentType;
import de.adorsys.psd2.xs2a.core.profile.ScaApproach;
import de.adorsys.psd2.xs2a.domain.account.SupportedAccountReferenceField;
import java.beans.ConstructorProperties;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;

@Service
public class AspspProfileServiceWrapper {
    private final AspspProfileService aspspProfileService;

    public List<PaymentProduct> getAvailablePaymentProducts() {
        List availablePaymentProducts = this.readAspspSettings().getAvailablePaymentProducts();
        return Optional.ofNullable(availablePaymentProducts).map(Collections::unmodifiableList).orElse(Collections.emptyList());
    }

    public List<PaymentType> getAvailablePaymentTypes() {
        return this.readAspspSettings().getAvailablePaymentTypes();
    }

    @Cacheable(value={"aspspProfileCash"})
    public ScaApproach getScaApproach() {
        ScaApproach scaApproach = this.aspspProfileService.getScaApproach();
        return Optional.ofNullable(scaApproach).map(approach -> ScaApproach.valueOf((String)approach.name())).orElse(ScaApproach.REDIRECT);
    }

    public Boolean getTppSignatureRequired() {
        return this.readAspspSettings().isTppSignatureRequired();
    }

    public String getPisRedirectUrlToAspsp() {
        return this.readAspspSettings().getPisRedirectUrlToAspsp();
    }

    public String getAisRedirectUrlToAspsp() {
        return this.readAspspSettings().getAisRedirectUrlToAspsp();
    }

    public List<SupportedAccountReferenceField> getSupportedAccountReferenceFields() {
        List supportedAccountReferenceFields = this.readAspspSettings().getSupportedAccountReferenceFields();
        return supportedAccountReferenceFields.stream().map(reference -> SupportedAccountReferenceField.valueOf(reference.name())).collect(Collectors.toList());
    }

    public int getConsentLifetime() {
        return this.readAspspSettings().getConsentLifetime();
    }

    public Boolean getAllPsd2Support() {
        return this.readAspspSettings().isAllPsd2Support();
    }

    public boolean isBankOfferedConsentSupported() {
        return this.readAspspSettings().isBankOfferedConsentSupport();
    }

    public boolean isTransactionsWithoutBalancesSupported() {
        return this.readAspspSettings().isTransactionsWithoutBalancesSupported();
    }

    public boolean isSigningBasketSupported() {
        return this.readAspspSettings().isSigningBasketSupported();
    }

    public boolean isPaymentCancellationAuthorizationMandated() {
        return this.readAspspSettings().isPaymentCancellationAuthorizationMandated();
    }

    public boolean isPiisConsentSupported() {
        return this.readAspspSettings().isPiisConsentSupported();
    }

    private AspspSettings readAspspSettings() {
        return this.aspspProfileService.getAspspSettings();
    }

    @ConstructorProperties(value={"aspspProfileService"})
    public AspspProfileServiceWrapper(AspspProfileService aspspProfileService) {
        this.aspspProfileService = aspspProfileService;
    }
}

