/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.service.payment;

import de.adorsys.psd2.xs2a.core.consent.AspspConsentData;
import de.adorsys.psd2.xs2a.core.profile.PaymentProduct;
import de.adorsys.psd2.xs2a.core.tpp.TppInfo;
import de.adorsys.psd2.xs2a.domain.consent.Xs2aPisConsent;
import de.adorsys.psd2.xs2a.domain.pis.BulkPayment;
import de.adorsys.psd2.xs2a.domain.pis.BulkPaymentInitiationResponse;
import de.adorsys.psd2.xs2a.domain.pis.PeriodicPayment;
import de.adorsys.psd2.xs2a.domain.pis.PeriodicPaymentInitiationResponse;
import de.adorsys.psd2.xs2a.domain.pis.SinglePayment;
import de.adorsys.psd2.xs2a.domain.pis.SinglePaymentInitiationResponse;
import de.adorsys.psd2.xs2a.service.consent.PisConsentDataService;
import de.adorsys.psd2.xs2a.service.mapper.spi_xs2a_mappers.SpiErrorMapper;
import de.adorsys.psd2.xs2a.service.mapper.spi_xs2a_mappers.SpiToXs2aPaymentMapper;
import de.adorsys.psd2.xs2a.service.mapper.spi_xs2a_mappers.Xs2aToSpiBulkPaymentMapper;
import de.adorsys.psd2.xs2a.service.mapper.spi_xs2a_mappers.Xs2aToSpiPeriodicPaymentMapper;
import de.adorsys.psd2.xs2a.service.mapper.spi_xs2a_mappers.Xs2aToSpiPsuDataMapper;
import de.adorsys.psd2.xs2a.service.mapper.spi_xs2a_mappers.Xs2aToSpiSinglePaymentMapper;
import de.adorsys.psd2.xs2a.service.payment.ScaPaymentService;
import de.adorsys.psd2.xs2a.spi.domain.payment.response.SpiPaymentInitiationResponse;
import de.adorsys.psd2.xs2a.spi.domain.psu.SpiPsuData;
import de.adorsys.psd2.xs2a.spi.domain.response.SpiResponse;
import de.adorsys.psd2.xs2a.spi.service.BulkPaymentSpi;
import de.adorsys.psd2.xs2a.spi.service.PeriodicPaymentSpi;
import de.adorsys.psd2.xs2a.spi.service.SinglePaymentSpi;
import java.beans.ConstructorProperties;
import org.springframework.stereotype.Service;

@Service
public class RedirectAndEmbeddedPaymentService
implements ScaPaymentService {
    private final SinglePaymentSpi singlePaymentSpi;
    private final PeriodicPaymentSpi periodicPaymentSpi;
    private final BulkPaymentSpi bulkPaymentSpi;
    private final Xs2aToSpiSinglePaymentMapper xs2AToSpiSinglePaymentMapper;
    private final Xs2aToSpiPeriodicPaymentMapper xs2aToSpiPeriodicPaymentMapper;
    private final Xs2aToSpiBulkPaymentMapper xs2aToSpiBulkPaymentMapper;
    private final SpiToXs2aPaymentMapper spiToXs2aPaymentMapper;
    private final Xs2aToSpiPsuDataMapper psuDataMapper;
    private final PisConsentDataService pisConsentDataService;
    private final SpiErrorMapper spiErrorMapper;

    @Override
    public SinglePaymentInitiationResponse createSinglePayment(SinglePayment payment, TppInfo tppInfo, PaymentProduct paymentProduct, Xs2aPisConsent pisConsent) {
        AspspConsentData aspspConsentData = this.pisConsentDataService.getAspspConsentData(pisConsent.getConsentId());
        SpiPsuData spiPsuData = this.psuDataMapper.mapToSpiPsuData(pisConsent.getPsuData());
        SpiResponse spiResponse = this.singlePaymentSpi.initiatePayment(spiPsuData, this.xs2AToSpiSinglePaymentMapper.mapToSpiSinglePayment(payment, paymentProduct), aspspConsentData);
        this.pisConsentDataService.updateAspspConsentData(spiResponse.getAspspConsentData());
        if (spiResponse.hasError()) {
            return new SinglePaymentInitiationResponse(this.spiErrorMapper.mapToErrorHolder(spiResponse));
        }
        return this.spiToXs2aPaymentMapper.mapToPaymentInitiateResponse((SpiPaymentInitiationResponse)spiResponse.getPayload(), SinglePaymentInitiationResponse::new);
    }

    @Override
    public PeriodicPaymentInitiationResponse createPeriodicPayment(PeriodicPayment payment, TppInfo tppInfo, PaymentProduct paymentProduct, Xs2aPisConsent pisConsent) {
        AspspConsentData aspspConsentData = this.pisConsentDataService.getAspspConsentData(pisConsent.getConsentId());
        SpiPsuData spiPsuData = this.psuDataMapper.mapToSpiPsuData(pisConsent.getPsuData());
        SpiResponse spiResponse = this.periodicPaymentSpi.initiatePayment(spiPsuData, this.xs2aToSpiPeriodicPaymentMapper.mapToSpiPeriodicPayment(payment, paymentProduct), aspspConsentData);
        this.pisConsentDataService.updateAspspConsentData(spiResponse.getAspspConsentData());
        if (spiResponse.hasError()) {
            return new PeriodicPaymentInitiationResponse(this.spiErrorMapper.mapToErrorHolder(spiResponse));
        }
        return this.spiToXs2aPaymentMapper.mapToPaymentInitiateResponse((SpiPaymentInitiationResponse)spiResponse.getPayload(), PeriodicPaymentInitiationResponse::new);
    }

    @Override
    public BulkPaymentInitiationResponse createBulkPayment(BulkPayment bulkPayment, TppInfo tppInfo, PaymentProduct paymentProduct, Xs2aPisConsent pisConsent) {
        AspspConsentData aspspConsentData = this.pisConsentDataService.getAspspConsentData(pisConsent.getConsentId());
        SpiPsuData spiPsuData = this.psuDataMapper.mapToSpiPsuData(pisConsent.getPsuData());
        SpiResponse spiResponse = this.bulkPaymentSpi.initiatePayment(spiPsuData, this.xs2aToSpiBulkPaymentMapper.mapToSpiBulkPayment(bulkPayment, paymentProduct), aspspConsentData);
        this.pisConsentDataService.updateAspspConsentData(spiResponse.getAspspConsentData());
        if (spiResponse.hasError()) {
            return new BulkPaymentInitiationResponse(this.spiErrorMapper.mapToErrorHolder(spiResponse));
        }
        return this.spiToXs2aPaymentMapper.mapToPaymentInitiateResponse((SpiPaymentInitiationResponse)spiResponse.getPayload(), BulkPaymentInitiationResponse::new);
    }

    @ConstructorProperties(value={"singlePaymentSpi", "periodicPaymentSpi", "bulkPaymentSpi", "xs2AToSpiSinglePaymentMapper", "xs2aToSpiPeriodicPaymentMapper", "xs2aToSpiBulkPaymentMapper", "spiToXs2aPaymentMapper", "psuDataMapper", "pisConsentDataService", "spiErrorMapper"})
    public RedirectAndEmbeddedPaymentService(SinglePaymentSpi singlePaymentSpi, PeriodicPaymentSpi periodicPaymentSpi, BulkPaymentSpi bulkPaymentSpi, Xs2aToSpiSinglePaymentMapper xs2AToSpiSinglePaymentMapper, Xs2aToSpiPeriodicPaymentMapper xs2aToSpiPeriodicPaymentMapper, Xs2aToSpiBulkPaymentMapper xs2aToSpiBulkPaymentMapper, SpiToXs2aPaymentMapper spiToXs2aPaymentMapper, Xs2aToSpiPsuDataMapper psuDataMapper, PisConsentDataService pisConsentDataService, SpiErrorMapper spiErrorMapper) {
        this.singlePaymentSpi = singlePaymentSpi;
        this.periodicPaymentSpi = periodicPaymentSpi;
        this.bulkPaymentSpi = bulkPaymentSpi;
        this.xs2AToSpiSinglePaymentMapper = xs2AToSpiSinglePaymentMapper;
        this.xs2aToSpiPeriodicPaymentMapper = xs2aToSpiPeriodicPaymentMapper;
        this.xs2aToSpiBulkPaymentMapper = xs2aToSpiBulkPaymentMapper;
        this.spiToXs2aPaymentMapper = spiToXs2aPaymentMapper;
        this.psuDataMapper = psuDataMapper;
        this.pisConsentDataService = pisConsentDataService;
        this.spiErrorMapper = spiErrorMapper;
    }
}

