/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.service.payment;

import de.adorsys.psd2.consent.api.pis.PisPayment;
import de.adorsys.psd2.xs2a.core.consent.AspspConsentData;
import de.adorsys.psd2.xs2a.core.profile.PaymentProduct;
import de.adorsys.psd2.xs2a.core.psu.PsuIdData;
import de.adorsys.psd2.xs2a.domain.pis.PaymentInformationResponse;
import de.adorsys.psd2.xs2a.domain.pis.SinglePayment;
import de.adorsys.psd2.xs2a.service.mapper.consent.CmsToXs2aPaymentMapper;
import de.adorsys.psd2.xs2a.service.mapper.spi_xs2a_mappers.SpiErrorMapper;
import de.adorsys.psd2.xs2a.service.mapper.spi_xs2a_mappers.SpiToXs2aSinglePaymentMapper;
import de.adorsys.psd2.xs2a.service.mapper.spi_xs2a_mappers.Xs2aToSpiSinglePaymentMapper;
import de.adorsys.psd2.xs2a.service.payment.ReadPaymentService;
import de.adorsys.psd2.xs2a.spi.domain.payment.SpiSinglePayment;
import de.adorsys.psd2.xs2a.spi.domain.psu.SpiPsuData;
import de.adorsys.psd2.xs2a.spi.domain.response.SpiResponse;
import de.adorsys.psd2.xs2a.spi.service.SinglePaymentSpi;
import java.beans.ConstructorProperties;
import org.springframework.stereotype.Service;

@Service(value="payments")
public class ReadSinglePaymentService
extends ReadPaymentService<PaymentInformationResponse<SinglePayment>> {
    private final SinglePaymentSpi singlePaymentSpi;
    private final CmsToXs2aPaymentMapper cmsToXs2aPaymentMapper;
    private final Xs2aToSpiSinglePaymentMapper xs2aToSpiSinglePaymentMapper;
    private final SpiToXs2aSinglePaymentMapper spiToXs2aSinglePaymentMapper;
    private final SpiErrorMapper spiErrorMapper;

    @Override
    public PaymentInformationResponse<SinglePayment> getPayment(PisPayment pisPayment, PaymentProduct paymentProduct, PsuIdData psuData, AspspConsentData aspspConsentData) {
        SinglePayment singlePayment = this.cmsToXs2aPaymentMapper.mapToSinglePayment(pisPayment);
        SpiSinglePayment spiPayment = this.xs2aToSpiSinglePaymentMapper.mapToSpiSinglePayment(singlePayment, paymentProduct);
        SpiPsuData spiPsuData = this.psuDataMapper.mapToSpiPsuData(psuData);
        SpiResponse spiResponse = this.singlePaymentSpi.getPaymentById(spiPsuData, spiPayment, aspspConsentData);
        this.pisConsentDataService.updateAspspConsentData(spiResponse.getAspspConsentData());
        if (spiResponse.hasError()) {
            return new PaymentInformationResponse<SinglePayment>(this.spiErrorMapper.mapToErrorHolder(spiResponse));
        }
        SpiSinglePayment spiSinglePayment = (SpiSinglePayment)spiResponse.getPayload();
        return new PaymentInformationResponse<SinglePayment>(this.spiToXs2aSinglePaymentMapper.mapToXs2aSinglePayment(spiSinglePayment));
    }

    @ConstructorProperties(value={"singlePaymentSpi", "cmsToXs2aPaymentMapper", "xs2aToSpiSinglePaymentMapper", "spiToXs2aSinglePaymentMapper", "spiErrorMapper"})
    public ReadSinglePaymentService(SinglePaymentSpi singlePaymentSpi, CmsToXs2aPaymentMapper cmsToXs2aPaymentMapper, Xs2aToSpiSinglePaymentMapper xs2aToSpiSinglePaymentMapper, SpiToXs2aSinglePaymentMapper spiToXs2aSinglePaymentMapper, SpiErrorMapper spiErrorMapper) {
        this.singlePaymentSpi = singlePaymentSpi;
        this.cmsToXs2aPaymentMapper = cmsToXs2aPaymentMapper;
        this.xs2aToSpiSinglePaymentMapper = xs2aToSpiSinglePaymentMapper;
        this.spiToXs2aSinglePaymentMapper = spiToXs2aSinglePaymentMapper;
        this.spiErrorMapper = spiErrorMapper;
    }
}

