/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.service.payment;

import de.adorsys.psd2.consent.api.pis.PisPayment;
import de.adorsys.psd2.xs2a.core.consent.AspspConsentData;
import de.adorsys.psd2.xs2a.core.profile.PaymentProduct;
import de.adorsys.psd2.xs2a.core.psu.PsuIdData;
import de.adorsys.psd2.xs2a.domain.pis.PaymentInformationResponse;
import de.adorsys.psd2.xs2a.domain.pis.PeriodicPayment;
import de.adorsys.psd2.xs2a.service.mapper.consent.CmsToXs2aPaymentMapper;
import de.adorsys.psd2.xs2a.service.mapper.spi_xs2a_mappers.SpiErrorMapper;
import de.adorsys.psd2.xs2a.service.mapper.spi_xs2a_mappers.SpiToXs2aPeriodicPaymentMapper;
import de.adorsys.psd2.xs2a.service.mapper.spi_xs2a_mappers.Xs2aToSpiPeriodicPaymentMapper;
import de.adorsys.psd2.xs2a.service.payment.ReadPaymentService;
import de.adorsys.psd2.xs2a.spi.domain.payment.SpiPeriodicPayment;
import de.adorsys.psd2.xs2a.spi.domain.psu.SpiPsuData;
import de.adorsys.psd2.xs2a.spi.domain.response.SpiResponse;
import de.adorsys.psd2.xs2a.spi.service.PeriodicPaymentSpi;
import java.beans.ConstructorProperties;
import org.springframework.stereotype.Service;

@Service(value="periodic-payments")
public class ReadPeriodicPaymentService
extends ReadPaymentService<PaymentInformationResponse<PeriodicPayment>> {
    private final PeriodicPaymentSpi periodicPaymentSpi;
    private final CmsToXs2aPaymentMapper cmsToXs2aPaymentMapper;
    private final Xs2aToSpiPeriodicPaymentMapper xs2aToSpiPeriodicPaymentMapper;
    private final SpiToXs2aPeriodicPaymentMapper spiToXs2aPeriodicPaymentMapper;
    private final SpiErrorMapper spiErrorMapper;

    @Override
    public PaymentInformationResponse<PeriodicPayment> getPayment(PisPayment pisPayment, PaymentProduct paymentProduct, PsuIdData psuData, AspspConsentData aspspConsentData) {
        PeriodicPayment periodicPayment = this.cmsToXs2aPaymentMapper.mapToPeriodicPayment(pisPayment);
        SpiPeriodicPayment spiPayment = this.xs2aToSpiPeriodicPaymentMapper.mapToSpiPeriodicPayment(periodicPayment, paymentProduct);
        SpiPsuData spiPsuData = this.psuDataMapper.mapToSpiPsuData(psuData);
        SpiResponse spiResponse = this.periodicPaymentSpi.getPaymentById(spiPsuData, spiPayment, aspspConsentData);
        this.pisConsentDataService.updateAspspConsentData(spiResponse.getAspspConsentData());
        if (spiResponse.hasError()) {
            return new PaymentInformationResponse<PeriodicPayment>(this.spiErrorMapper.mapToErrorHolder(spiResponse));
        }
        SpiPeriodicPayment spiResponsePayment = (SpiPeriodicPayment)spiResponse.getPayload();
        return new PaymentInformationResponse<PeriodicPayment>(this.spiToXs2aPeriodicPaymentMapper.mapToXs2aPeriodicPayment(spiResponsePayment));
    }

    @ConstructorProperties(value={"periodicPaymentSpi", "cmsToXs2aPaymentMapper", "xs2aToSpiPeriodicPaymentMapper", "spiToXs2aPeriodicPaymentMapper", "spiErrorMapper"})
    public ReadPeriodicPaymentService(PeriodicPaymentSpi periodicPaymentSpi, CmsToXs2aPaymentMapper cmsToXs2aPaymentMapper, Xs2aToSpiPeriodicPaymentMapper xs2aToSpiPeriodicPaymentMapper, SpiToXs2aPeriodicPaymentMapper spiToXs2aPeriodicPaymentMapper, SpiErrorMapper spiErrorMapper) {
        this.periodicPaymentSpi = periodicPaymentSpi;
        this.cmsToXs2aPaymentMapper = cmsToXs2aPaymentMapper;
        this.xs2aToSpiPeriodicPaymentMapper = xs2aToSpiPeriodicPaymentMapper;
        this.spiToXs2aPeriodicPaymentMapper = spiToXs2aPeriodicPaymentMapper;
        this.spiErrorMapper = spiErrorMapper;
    }
}

