/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.service.payment;

import de.adorsys.psd2.consent.api.pis.PisPayment;
import de.adorsys.psd2.xs2a.core.consent.AspspConsentData;
import de.adorsys.psd2.xs2a.core.profile.PaymentProduct;
import de.adorsys.psd2.xs2a.core.psu.PsuIdData;
import de.adorsys.psd2.xs2a.domain.pis.BulkPayment;
import de.adorsys.psd2.xs2a.domain.pis.PaymentInformationResponse;
import de.adorsys.psd2.xs2a.service.mapper.consent.CmsToXs2aPaymentMapper;
import de.adorsys.psd2.xs2a.service.mapper.spi_xs2a_mappers.SpiErrorMapper;
import de.adorsys.psd2.xs2a.service.mapper.spi_xs2a_mappers.SpiToXs2aBulkPaymentMapper;
import de.adorsys.psd2.xs2a.service.mapper.spi_xs2a_mappers.Xs2aToSpiBulkPaymentMapper;
import de.adorsys.psd2.xs2a.service.payment.ReadPaymentService;
import de.adorsys.psd2.xs2a.spi.domain.payment.SpiBulkPayment;
import de.adorsys.psd2.xs2a.spi.domain.psu.SpiPsuData;
import de.adorsys.psd2.xs2a.spi.domain.response.SpiResponse;
import de.adorsys.psd2.xs2a.spi.service.BulkPaymentSpi;
import java.beans.ConstructorProperties;
import java.util.Collections;
import org.springframework.stereotype.Service;

@Service(value="bulk-payments")
public class ReadBulkPaymentService
extends ReadPaymentService<PaymentInformationResponse<BulkPayment>> {
    private final BulkPaymentSpi bulkPaymentSpi;
    private final CmsToXs2aPaymentMapper cmsToXs2aPaymentMapper;
    private final Xs2aToSpiBulkPaymentMapper xs2aToSpiBulkPaymentMapper;
    private final SpiToXs2aBulkPaymentMapper spiToXs2aBulkPaymentMapper;
    private final SpiErrorMapper spiErrorMapper;

    @Override
    public PaymentInformationResponse<BulkPayment> getPayment(PisPayment pisPayment, PaymentProduct paymentProduct, PsuIdData psuData, AspspConsentData aspspConsentData) {
        BulkPayment bulkPayment = this.cmsToXs2aPaymentMapper.mapToBulkPayment(Collections.singletonList(pisPayment));
        SpiBulkPayment spiPayment = this.xs2aToSpiBulkPaymentMapper.mapToSpiBulkPayment(bulkPayment, paymentProduct);
        SpiPsuData spiPsuData = this.psuDataMapper.mapToSpiPsuData(psuData);
        SpiResponse spiResponse = this.bulkPaymentSpi.getPaymentById(spiPsuData, spiPayment, aspspConsentData);
        this.pisConsentDataService.updateAspspConsentData(spiResponse.getAspspConsentData());
        if (spiResponse.hasError()) {
            return new PaymentInformationResponse<BulkPayment>(this.spiErrorMapper.mapToErrorHolder(spiResponse));
        }
        SpiBulkPayment spiResponsePayment = (SpiBulkPayment)spiResponse.getPayload();
        return new PaymentInformationResponse<BulkPayment>(this.spiToXs2aBulkPaymentMapper.mapToXs2aBulkPayment(spiResponsePayment));
    }

    @ConstructorProperties(value={"bulkPaymentSpi", "cmsToXs2aPaymentMapper", "xs2aToSpiBulkPaymentMapper", "spiToXs2aBulkPaymentMapper", "spiErrorMapper"})
    public ReadBulkPaymentService(BulkPaymentSpi bulkPaymentSpi, CmsToXs2aPaymentMapper cmsToXs2aPaymentMapper, Xs2aToSpiBulkPaymentMapper xs2aToSpiBulkPaymentMapper, SpiToXs2aBulkPaymentMapper spiToXs2aBulkPaymentMapper, SpiErrorMapper spiErrorMapper) {
        this.bulkPaymentSpi = bulkPaymentSpi;
        this.cmsToXs2aPaymentMapper = cmsToXs2aPaymentMapper;
        this.xs2aToSpiBulkPaymentMapper = xs2aToSpiBulkPaymentMapper;
        this.spiToXs2aBulkPaymentMapper = spiToXs2aBulkPaymentMapper;
        this.spiErrorMapper = spiErrorMapper;
    }
}

