/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.service.payment;

import de.adorsys.psd2.xs2a.core.profile.PaymentType;
import de.adorsys.psd2.xs2a.core.tpp.TppInfo;
import de.adorsys.psd2.xs2a.domain.MessageErrorCode;
import de.adorsys.psd2.xs2a.domain.ResponseObject;
import de.adorsys.psd2.xs2a.domain.consent.Xs2aPisConsent;
import de.adorsys.psd2.xs2a.domain.consent.Xsa2CreatePisConsentAuthorisationResponse;
import de.adorsys.psd2.xs2a.domain.pis.PaymentInitiationParameters;
import de.adorsys.psd2.xs2a.domain.pis.SinglePayment;
import de.adorsys.psd2.xs2a.domain.pis.SinglePaymentInitiationResponse;
import de.adorsys.psd2.xs2a.exception.MessageError;
import de.adorsys.psd2.xs2a.service.authorization.AuthorisationMethodService;
import de.adorsys.psd2.xs2a.service.authorization.pis.PisScaAuthorisationService;
import de.adorsys.psd2.xs2a.service.consent.PisConsentDataService;
import de.adorsys.psd2.xs2a.service.consent.Xs2aPisConsentService;
import de.adorsys.psd2.xs2a.service.payment.CreatePaymentService;
import de.adorsys.psd2.xs2a.service.payment.ScaPaymentService;
import java.beans.ConstructorProperties;
import java.util.Optional;
import org.springframework.stereotype.Service;

@Service
public class CreateSinglePaymentService
implements CreatePaymentService<SinglePayment, SinglePaymentInitiationResponse> {
    private final ScaPaymentService scaPaymentService;
    private final Xs2aPisConsentService pisConsentService;
    private final PisScaAuthorisationService pisScaAuthorisationService;
    private final AuthorisationMethodService authorisationMethodService;
    private final PisConsentDataService pisConsentDataService;

    @Override
    public ResponseObject<SinglePaymentInitiationResponse> createPayment(SinglePayment singlePayment, PaymentInitiationParameters paymentInitiationParameters, TppInfo tppInfo, Xs2aPisConsent pisConsent) {
        String externalPaymentId = pisConsent.getConsentId();
        String internalPaymentId = this.pisConsentDataService.getInternalPaymentIdByEncryptedString(externalPaymentId);
        singlePayment.setPaymentId(internalPaymentId);
        SinglePaymentInitiationResponse response = this.scaPaymentService.createSinglePayment(singlePayment, tppInfo, paymentInitiationParameters.getPaymentProduct(), pisConsent);
        response.setPisConsentId(pisConsent.getConsentId());
        singlePayment.setTransactionStatus(response.getTransactionStatus());
        this.pisConsentService.updateSinglePaymentInPisConsent(singlePayment, paymentInitiationParameters, pisConsent.getConsentId());
        boolean implicitMethod = this.authorisationMethodService.isImplicitMethod(paymentInitiationParameters.isTppExplicitAuthorisationPreferred());
        if (implicitMethod) {
            Optional<Xsa2CreatePisConsentAuthorisationResponse> consentAuthorisation = this.pisScaAuthorisationService.createConsentAuthorisation(externalPaymentId, PaymentType.SINGLE, paymentInitiationParameters.getPsuData());
            if (!consentAuthorisation.isPresent()) {
                return ResponseObject.builder().fail(new MessageError(MessageErrorCode.CONSENT_INVALID)).build();
            }
            Xsa2CreatePisConsentAuthorisationResponse authorisationResponse = consentAuthorisation.get();
            response.setAuthorizationId(authorisationResponse.getAuthorizationId());
            response.setScaStatus(authorisationResponse.getScaStatus());
        }
        response.setPaymentId(externalPaymentId);
        return ResponseObject.builder().body(response).build();
    }

    @ConstructorProperties(value={"scaPaymentService", "pisConsentService", "pisScaAuthorisationService", "authorisationMethodService", "pisConsentDataService"})
    public CreateSinglePaymentService(ScaPaymentService scaPaymentService, Xs2aPisConsentService pisConsentService, PisScaAuthorisationService pisScaAuthorisationService, AuthorisationMethodService authorisationMethodService, PisConsentDataService pisConsentDataService) {
        this.scaPaymentService = scaPaymentService;
        this.pisConsentService = pisConsentService;
        this.pisScaAuthorisationService = pisScaAuthorisationService;
        this.authorisationMethodService = authorisationMethodService;
        this.pisConsentDataService = pisConsentDataService;
    }
}

