/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.service.payment;

import de.adorsys.psd2.xs2a.core.profile.PaymentType;
import de.adorsys.psd2.xs2a.core.tpp.TppInfo;
import de.adorsys.psd2.xs2a.domain.MessageErrorCode;
import de.adorsys.psd2.xs2a.domain.ResponseObject;
import de.adorsys.psd2.xs2a.domain.consent.Xs2aPisConsent;
import de.adorsys.psd2.xs2a.domain.consent.Xsa2CreatePisConsentAuthorisationResponse;
import de.adorsys.psd2.xs2a.domain.pis.PaymentInitiationParameters;
import de.adorsys.psd2.xs2a.domain.pis.PeriodicPayment;
import de.adorsys.psd2.xs2a.domain.pis.PeriodicPaymentInitiationResponse;
import de.adorsys.psd2.xs2a.exception.MessageError;
import de.adorsys.psd2.xs2a.service.authorization.AuthorisationMethodService;
import de.adorsys.psd2.xs2a.service.authorization.pis.PisScaAuthorisationService;
import de.adorsys.psd2.xs2a.service.consent.PisConsentDataService;
import de.adorsys.psd2.xs2a.service.consent.Xs2aPisConsentService;
import de.adorsys.psd2.xs2a.service.payment.CreatePaymentService;
import de.adorsys.psd2.xs2a.service.payment.ScaPaymentService;
import java.beans.ConstructorProperties;
import java.util.Optional;
import org.springframework.stereotype.Service;

@Service
public class CreatePeriodicPaymentService
implements CreatePaymentService<PeriodicPayment, PeriodicPaymentInitiationResponse> {
    private final ScaPaymentService scaPaymentService;
    private final Xs2aPisConsentService pisConsentService;
    private final AuthorisationMethodService authorisationMethodService;
    private final PisScaAuthorisationService pisScaAuthorisationService;
    private final PisConsentDataService pisConsentDataService;

    @Override
    public ResponseObject<PeriodicPaymentInitiationResponse> createPayment(PeriodicPayment periodicPayment, PaymentInitiationParameters paymentInitiationParameters, TppInfo tppInfo, Xs2aPisConsent pisConsent) {
        String externalPaymentId = pisConsent.getConsentId();
        String internalPaymentId = this.pisConsentDataService.getInternalPaymentIdByEncryptedString(externalPaymentId);
        periodicPayment.setPaymentId(internalPaymentId);
        PeriodicPaymentInitiationResponse response = this.scaPaymentService.createPeriodicPayment(periodicPayment, tppInfo, paymentInitiationParameters.getPaymentProduct(), pisConsent);
        response.setPisConsentId(pisConsent.getConsentId());
        periodicPayment.setTransactionStatus(response.getTransactionStatus());
        this.pisConsentService.updatePeriodicPaymentInPisConsent(periodicPayment, paymentInitiationParameters, pisConsent.getConsentId());
        boolean implicitMethod = this.authorisationMethodService.isImplicitMethod(paymentInitiationParameters.isTppExplicitAuthorisationPreferred());
        if (implicitMethod) {
            Optional<Xsa2CreatePisConsentAuthorisationResponse> consentAuthorisation = this.pisScaAuthorisationService.createConsentAuthorisation(externalPaymentId, PaymentType.PERIODIC, paymentInitiationParameters.getPsuData());
            if (!consentAuthorisation.isPresent()) {
                return ResponseObject.builder().fail(new MessageError(MessageErrorCode.CONSENT_INVALID)).build();
            }
            Xsa2CreatePisConsentAuthorisationResponse authorisationResponse = consentAuthorisation.get();
            response.setAuthorizationId(authorisationResponse.getAuthorizationId());
            response.setScaStatus(authorisationResponse.getScaStatus());
        }
        response.setPaymentId(externalPaymentId);
        return ResponseObject.builder().body(response).build();
    }

    @ConstructorProperties(value={"scaPaymentService", "pisConsentService", "authorisationMethodService", "pisScaAuthorisationService", "pisConsentDataService"})
    public CreatePeriodicPaymentService(ScaPaymentService scaPaymentService, Xs2aPisConsentService pisConsentService, AuthorisationMethodService authorisationMethodService, PisScaAuthorisationService pisScaAuthorisationService, PisConsentDataService pisConsentDataService) {
        this.scaPaymentService = scaPaymentService;
        this.pisConsentService = pisConsentService;
        this.authorisationMethodService = authorisationMethodService;
        this.pisScaAuthorisationService = pisScaAuthorisationService;
        this.pisConsentDataService = pisConsentDataService;
    }
}

